/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable.gui;

import com.google.common.base.Predicates;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.integrateddynamics.api.client.gui.subgui.IGuiInputElementValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.logicprogrammer.IConfigRenderPattern;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBoolean;
import org.cyclops.integrateddynamics.core.evaluate.variable.gui.GuiElementValueTypeBooleanRenderPattern;

public class GuiElementValueTypeBoolean<G extends AbstractGui, C extends Container>
implements IGuiInputElementValueType<GuiElementValueTypeBooleanRenderPattern, G, C> {
    private final ValueTypeBoolean valueType;
    private Predicate<IValue> validator;
    private final IConfigRenderPattern renderPattern;
    private final boolean defaultInputBoolean;
    private boolean inputBoolean;

    public GuiElementValueTypeBoolean(ValueTypeBoolean valueType, IConfigRenderPattern renderPattern) {
        this.valueType = valueType;
        this.validator = Predicates.alwaysTrue();
        this.renderPattern = renderPattern;
        this.defaultInputBoolean = valueType.getDefault().getRawValue();
    }

    public boolean getDefaultInputBoolean() {
        return this.inputBoolean;
    }

    public boolean getInputBoolean() {
        return this.inputBoolean;
    }

    @Override
    public void setValue(IValue value, GuiElementValueTypeBooleanRenderPattern propertyConfigPattern) {
        this.setInputBoolean(((ValueTypeBoolean.ValueBoolean)value).getRawValue(), propertyConfigPattern);
    }

    public void setInputBoolean(boolean inputBoolean, GuiElementValueTypeBooleanRenderPattern subGui) {
        this.inputBoolean = inputBoolean;
        if (subGui != null) {
            subGui.getCheckbox().setChecked(inputBoolean);
        }
    }

    @Override
    public void setValidator(Predicate<IValue> validator) {
        this.validator = validator;
    }

    @Override
    public IValue getValue() {
        return ValueTypeBoolean.ValueBoolean.of(this.getInputBoolean());
    }

    @Override
    public ITextComponent getName() {
        return new TranslationTextComponent(this.getValueType().getTranslationKey());
    }

    @Override
    public void loadTooltip(List<ITextComponent> lines) {
        this.getValueType().loadTooltip(lines, true, null);
    }

    @Override
    public IConfigRenderPattern getRenderPattern() {
        return this.renderPattern;
    }

    @Override
    public void activate() {
        this.inputBoolean = this.defaultInputBoolean;
    }

    @Override
    public void deactivate() {
    }

    @Override
    public ITextComponent validate() {
        if (!this.validator.test(ValueTypeBoolean.ValueBoolean.of(this.inputBoolean))) {
            return new TranslationTextComponent("valuetype.integrateddynamics.error.value");
        }
        return null;
    }

    @Override
    public int getColor() {
        return this.getValueType().getDisplayColor();
    }

    @Override
    public String getSymbol() {
        return L10NHelpers.localize((String)this.getValueType().getTranslationKey(), (Object[])new Object[0]);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiElementValueTypeBooleanRenderPattern<?, G, C> createSubGui(int baseX, int baseY, int maxWidth, int maxHeight, G gui, C container) {
        return new GuiElementValueTypeBooleanRenderPattern(this, baseX, baseY, maxWidth, maxHeight, gui, container);
    }

    public ValueTypeBoolean getValueType() {
        return this.valueType;
    }

    public Predicate<IValue> getValidator() {
        return this.validator;
    }

    public void setInputBoolean(boolean inputBoolean) {
        this.inputBoolean = inputBoolean;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GuiElementValueTypeBoolean)) {
            return false;
        }
        GuiElementValueTypeBoolean other = (GuiElementValueTypeBoolean)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ValueTypeBoolean this$valueType = this.getValueType();
        ValueTypeBoolean other$valueType = other.getValueType();
        if (this$valueType == null ? other$valueType != null : !this$valueType.equals(other$valueType)) {
            return false;
        }
        Predicate<IValue> this$validator = this.getValidator();
        Predicate<IValue> other$validator = other.getValidator();
        if (this$validator == null ? other$validator != null : !this$validator.equals(other$validator)) {
            return false;
        }
        IConfigRenderPattern this$renderPattern = this.getRenderPattern();
        IConfigRenderPattern other$renderPattern = other.getRenderPattern();
        if (this$renderPattern == null ? other$renderPattern != null : !this$renderPattern.equals(other$renderPattern)) {
            return false;
        }
        if (this.getDefaultInputBoolean() != other.getDefaultInputBoolean()) {
            return false;
        }
        return this.getInputBoolean() == other.getInputBoolean();
    }

    protected boolean canEqual(Object other) {
        return other instanceof GuiElementValueTypeBoolean;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ValueTypeBoolean $valueType = this.getValueType();
        result = result * 59 + ($valueType == null ? 0 : $valueType.hashCode());
        Predicate<IValue> $validator = this.getValidator();
        result = result * 59 + ($validator == null ? 0 : $validator.hashCode());
        IConfigRenderPattern $renderPattern = this.getRenderPattern();
        result = result * 59 + ($renderPattern == null ? 0 : $renderPattern.hashCode());
        result = result * 59 + (this.getDefaultInputBoolean() ? 79 : 97);
        result = result * 59 + (this.getInputBoolean() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "GuiElementValueTypeBoolean(valueType=" + this.getValueType() + ", validator=" + this.getValidator() + ", renderPattern=" + this.getRenderPattern() + ", defaultInputBoolean=" + this.getDefaultInputBoolean() + ", inputBoolean=" + this.getInputBoolean() + ")";
    }
}

