/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.operator;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperatorSerializer;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.logicprogrammer.IConfigRenderPattern;
import org.cyclops.integrateddynamics.core.evaluate.operator.OperatorBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBoolean;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;

public class PredicateOperator<T extends IValueType<V>, V extends IValue>
extends OperatorBase {
    private final String unlocalizedType;
    private final T inputType;
    private final List<V> rawValues;

    public PredicateOperator(T inputType, List<V> rawValues) {
        this(rawValues::contains, inputType, rawValues);
    }

    public PredicateOperator(Predicate<V> predicate, T inputType, List<V> rawValues) {
        super("pred", "pred", new IValueType[]{inputType}, ValueTypes.BOOLEAN, variables -> ValueTypeBoolean.ValueBoolean.of(predicate.test(variables.getValue(0, inputType))), IConfigRenderPattern.PREFIX_1);
        this.inputType = inputType;
        this.rawValues = rawValues;
        this.unlocalizedType = "predicate";
    }

    @Override
    protected String getUnlocalizedType() {
        return this.unlocalizedType;
    }

    @Override
    public IOperator materialize() {
        return this;
    }

    public static class Serializer
    implements IOperatorSerializer<PredicateOperator<IValueType<IValue>, IValue>> {
        @Override
        public boolean canHandle(IOperator operator) {
            return operator instanceof PredicateOperator;
        }

        @Override
        public ResourceLocation getUniqueName() {
            return new ResourceLocation("integrateddynamics", "predicate");
        }

        @Override
        public INBT serialize(PredicateOperator<IValueType<IValue>, IValue> operator) {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74778_a("valueType", ((PredicateOperator)operator).inputType.getTranslationKey());
            ListNBT list = new ListNBT();
            for (IValue rawValue : ((PredicateOperator)operator).rawValues) {
                list.add((Object)((PredicateOperator)operator).inputType.serialize(rawValue));
            }
            tag.func_218657_a("values", (INBT)list);
            return tag;
        }

        @Override
        public PredicateOperator<IValueType<IValue>, IValue> deserialize(INBT value) throws EvaluationException {
            try {
                CompoundNBT tag = (CompoundNBT)value;
                IValueType valueType = ValueTypes.REGISTRY.getValueType(new ResourceLocation(tag.func_74779_i("valueType")));
                ListNBT list = (ListNBT)tag.func_74781_a("values");
                ArrayList values = Lists.newArrayList();
                for (INBT subTag : list) {
                    values.add(ValueHelpers.deserializeRaw(valueType, subTag));
                }
                return new PredicateOperator<IValueType<IValue>, IValue>(valueType, values);
            }
            catch (ClassCastException e) {
                e.printStackTrace();
                throw new EvaluationException((IFormattableTextComponent)new TranslationTextComponent("valuetype.integrateddynamics.error.deserialize", new Object[]{value, e.getMessage()}));
            }
        }
    }
}

