/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.operator;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.persist.nbt.INBTProvider;
import org.cyclops.cyclopscore.persist.nbt.NBTClassType;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperatorSerializer;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.logicprogrammer.IConfigRenderPattern;
import org.cyclops.integrateddynamics.core.evaluate.operator.OperatorBase;

public abstract class PositionedOperator
extends OperatorBase
implements INBTProvider {
    private DimPos pos;
    private Direction side;

    protected PositionedOperator(String symbol, String operatorName, IValueType[] inputTypes, IValueType outputType, OperatorBase.IFunction function, IConfigRenderPattern renderPattern, DimPos pos, Direction side) {
        super(symbol, operatorName, inputTypes, outputType, function, renderPattern);
        this.pos = pos;
        this.side = side;
    }

    @Override
    public IOperator materialize() {
        return this;
    }

    public void writeGeneratedFieldsToNBT(CompoundNBT tag) {
        NBTClassType.writeNbt(DimPos.class, (String)"pos", (Object)this.pos, (CompoundNBT)tag);
        NBTClassType.writeNbt(Direction.class, (String)"side", (Object)this.side, (CompoundNBT)tag);
    }

    public void readGeneratedFieldsFromNBT(CompoundNBT tag) {
        this.pos = (DimPos)NBTClassType.readNbt(DimPos.class, (String)"pos", (CompoundNBT)tag);
        this.side = (Direction)NBTClassType.readNbt(Direction.class, (String)"side", (CompoundNBT)tag);
    }

    public DimPos getPos() {
        return this.pos;
    }

    public void setPos(DimPos pos) {
        this.pos = pos;
    }

    public Direction getSide() {
        return this.side;
    }

    public void setSide(Direction side) {
        this.side = side;
    }

    public static class Serializer
    implements IOperatorSerializer<PositionedOperator> {
        private final Class<? extends PositionedOperator> clazz;
        private final ResourceLocation uniqueName;

        public Serializer(Class<? extends PositionedOperator> clazz, ResourceLocation uniqueName) {
            this.clazz = clazz;
            this.uniqueName = uniqueName;
        }

        @Override
        public boolean canHandle(IOperator operator) {
            return this.clazz.isInstance(operator);
        }

        @Override
        public ResourceLocation getUniqueName() {
            return this.uniqueName;
        }

        @Override
        public INBT serialize(PositionedOperator operator) {
            CompoundNBT tag = new CompoundNBT();
            operator.writeGeneratedFieldsToNBT(tag);
            return tag;
        }

        @Override
        public PositionedOperator deserialize(INBT value) throws EvaluationException {
            try {
                Constructor<? extends PositionedOperator> constructor = this.clazz.getConstructor(new Class[0]);
                PositionedOperator proxy = constructor.newInstance(new Object[0]);
                proxy.readGeneratedFieldsFromNBT((CompoundNBT)value);
                return proxy;
            }
            catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
                throw new EvaluationException((IFormattableTextComponent)new TranslationTextComponent("valuetype.integrateddynamics.error.deserialize", new Object[]{value, e.getMessage()}));
            }
        }
    }
}

