/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.item.IVariableFacade;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHandlerRegistry;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.network.event.VariableContentsUpdatedEvent;

public class InventoryVariableEvaluator<V extends IValue>
implements IVariableFacade.IValidator {
    private final IVariableFacadeHandlerRegistry handler = (IVariableFacadeHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IVariableFacadeHandlerRegistry.class);
    private final IInventory inventory;
    private final int slot;
    private final IValueType containingValueType;
    private IVariableFacade variableStored = null;
    private List<IFormattableTextComponent> errors = Lists.newLinkedList();

    public InventoryVariableEvaluator(IInventory inventory, int slot, IValueType<V> containingValueType) {
        this.inventory = inventory;
        this.slot = slot;
        this.containingValueType = containingValueType;
    }

    public boolean hasVariable() {
        return !this.inventory.func_70301_a(this.slot).func_190926_b();
    }

    public void refreshVariable(@Nullable INetwork network, boolean sendVariablesUpdateEvent) {
        IPartNetwork partNetwork = (IPartNetwork)NetworkHelpers.getPartNetwork(network).orElse(null);
        int lastVariabledId = this.variableStored == null ? -1 : this.variableStored.getId();
        int variableId = -1;
        if (!this.inventory.func_70301_a(this.slot).func_190926_b() && NetworkHelpers.shouldWork()) {
            ItemStack itemStack = this.inventory.func_70301_a(this.slot);
            this.variableStored = this.handler.handle(itemStack);
            if (this.variableStored != null) {
                variableId = this.variableStored.getId();
            }
        } else {
            this.variableStored = null;
        }
        this.clearErrors();
        if (partNetwork == null) {
            this.addError((IFormattableTextComponent)new TranslationTextComponent("general.integrateddynamics.error.no_network"));
        } else if (this.variableStored != null) {
            this.preValidate();
            try {
                this.variableStored.validate(partNetwork, this, this.containingValueType);
            }
            catch (IllegalArgumentException e) {
                this.addError((IFormattableTextComponent)new TranslationTextComponent(e.getMessage()));
            }
        }
        if (sendVariablesUpdateEvent && partNetwork != null && lastVariabledId != variableId) {
            network.getEventBus().post(new VariableContentsUpdatedEvent(network));
        }
    }

    @Nullable
    public IVariable<V> getVariable(INetwork network) {
        return this.getVariable(NetworkHelpers.getPartNetworkChecked(network));
    }

    @Nullable
    public IVariable<V> getVariable(IPartNetwork network) {
        if (this.getVariableFacade() == null || !this.getErrors().isEmpty()) {
            return null;
        }
        try {
            return this.getVariableFacade().getVariable(network);
        }
        catch (IllegalArgumentException e) {
            this.addError((IFormattableTextComponent)new TranslationTextComponent(e.getMessage()));
            return null;
        }
    }

    public IVariableFacade getVariableFacade() {
        return this.variableStored;
    }

    protected void preValidate() {
    }

    public void clearErrors() {
        this.errors.clear();
        this.onErrorsChanged();
    }

    public void setErrors(List<IFormattableTextComponent> errors) {
        this.errors = errors;
        this.onErrorsChanged();
    }

    public List<IFormattableTextComponent> getErrors() {
        return this.errors;
    }

    @Override
    public void addError(IFormattableTextComponent error) {
        this.errors.add(error);
    }

    public void onErrorsChanged() {
    }
}

