/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.block;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.world.IBlockReader;
import org.cyclops.integrateddynamics.core.block.VoxelShapeComponents;

public class VoxelShapeComponentsFactory {
    private final List<IHandler> handlers = Lists.newArrayList();

    public VoxelShapeComponentsFactory(IHandler ... handlers) {
        for (IHandler handler : handlers) {
            this.addHandler(handler);
        }
    }

    public void addHandler(IHandler handler) {
        this.handlers.add(handler);
    }

    public VoxelShapeComponents createShape(BlockState blockState, IBlockReader world, BlockPos blockPos, ISelectionContext selectionContext) {
        ArrayList components = Lists.newArrayList();
        for (IHandler handler : this.handlers) {
            components.addAll(handler.createComponents(blockState, world, blockPos));
        }
        return VoxelShapeComponents.create(blockState, world, blockPos, selectionContext, components);
    }

    public static interface IHandler {
        public Collection<VoxelShapeComponents.IComponent> createComponents(BlockState var1, IBlockReader var2, BlockPos var3);
    }
}

