/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.block;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.block.BlockTile;
import org.cyclops.cyclopscore.helper.InventoryHelpers;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.integrateddynamics.tileentity.TileSqueezer;

public class BlockSqueezer
extends BlockTile {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.field_208199_z;
    public static final IntegerProperty HEIGHT = IntegerProperty.func_177719_a((String)"height", (int)1, (int)7);
    private static final VoxelShape[] SHAPES_BLOCK = new VoxelShape[]{null, BlockSqueezer.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), BlockSqueezer.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), BlockSqueezer.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), BlockSqueezer.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), BlockSqueezer.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), BlockSqueezer.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), BlockSqueezer.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0)};
    private static final VoxelShape[] SHAPES_STICKS = new VoxelShape[]{BlockSqueezer.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)2.0), BlockSqueezer.func_208617_a((double)16.0, (double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)2.0), BlockSqueezer.func_208617_a((double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0, (double)14.0), BlockSqueezer.func_208617_a((double)16.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0, (double)14.0)};
    private static final VoxelShape[] SHAPES = new VoxelShape[]{null, VoxelShapes.func_216384_a((VoxelShape)SHAPES_BLOCK[1], (VoxelShape[])SHAPES_STICKS), VoxelShapes.func_216384_a((VoxelShape)SHAPES_BLOCK[2], (VoxelShape[])SHAPES_STICKS), VoxelShapes.func_216384_a((VoxelShape)SHAPES_BLOCK[3], (VoxelShape[])SHAPES_STICKS), VoxelShapes.func_216384_a((VoxelShape)SHAPES_BLOCK[4], (VoxelShape[])SHAPES_STICKS), VoxelShapes.func_216384_a((VoxelShape)SHAPES_BLOCK[5], (VoxelShape[])SHAPES_STICKS), VoxelShapes.func_216384_a((VoxelShape)SHAPES_BLOCK[6], (VoxelShape[])SHAPES_STICKS), VoxelShapes.func_216384_a((VoxelShape)SHAPES_BLOCK[7], (VoxelShape[])SHAPES_STICKS)};

    public BlockSqueezer(AbstractBlock.Properties properties) {
        super(properties, TileSqueezer::new);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(AXIS, (Comparable)Direction.Axis.X)).func_206870_a((Property)HEIGHT, (Comparable)Integer.valueOf(1)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{AXIS, HEIGHT});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a(AXIS, (Comparable)context.func_195992_f().func_176740_k());
    }

    public ActionResultType func_225533_a_(BlockState blockState, World world, BlockPos blockPos, PlayerEntity player, Hand hand, BlockRayTraceResult blockRayTraceResult) {
        if (world.func_201670_d()) {
            return ActionResultType.SUCCESS;
        }
        if ((Integer)world.func_180495_p(blockPos).func_177229_b((Property)HEIGHT) == 1) {
            return TileHelpers.getSafeTile((IBlockReader)world, (BlockPos)blockPos, TileSqueezer.class).map(tile -> {
                ItemStack itemStack = player.field_71071_by.func_70448_g();
                ItemStack tileStack = tile.getInventory().func_70301_a(0);
                if (itemStack.func_190926_b() && !tileStack.func_190926_b()) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, tileStack);
                    tile.getInventory().func_70299_a(0, ItemStack.field_190927_a);
                    tile.sendUpdate();
                    return ActionResultType.SUCCESS;
                }
                if (player.field_71071_by.func_70441_a(tileStack)) {
                    tile.getInventory().func_70299_a(0, ItemStack.field_190927_a);
                    tile.sendUpdate();
                    return ActionResultType.SUCCESS;
                }
                if (!itemStack.func_190926_b() && tile.getInventory().func_70301_a(0).func_190926_b()) {
                    tile.getInventory().func_70299_a(0, itemStack.func_77979_a(1));
                    if (itemStack.func_190916_E() <= 0) {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
                    }
                    tile.sendUpdate();
                    return ActionResultType.SUCCESS;
                }
                return ActionResultType.PASS;
            }).orElse(ActionResultType.PASS);
        }
        return ActionResultType.PASS;
    }

    public void func_176216_a(IBlockReader worldIn, Entity entityIn) {
        double motionY = entityIn.func_213322_ci().field_72448_b;
        super.func_176216_a(worldIn, entityIn);
        if (!entityIn.func_130014_f_().func_201670_d() && motionY <= -0.37 && entityIn instanceof LivingEntity) {
            int i = MathHelper.func_76128_c((double)entityIn.func_226277_ct_());
            int j = MathHelper.func_76128_c((double)(entityIn.func_226278_cu_() - 0.2));
            int k = MathHelper.func_76128_c((double)entityIn.func_226281_cx_());
            BlockPos blockPos = new BlockPos(i, j, k);
            BlockState blockState = worldIn.func_180495_p(blockPos);
            int steps = 1 + MathHelper.func_76128_c((double)((-motionY - 0.37) * 5.0));
            if (entityIn.func_226278_cu_() - (double)blockPos.func_177956_o() - (double)this.getRelativeTopPositionTop(worldIn, blockPos, blockState) <= (double)0.1f && blockState.func_177230_c() == this) {
                int newHeight = Math.min(7, (Integer)blockState.func_177229_b((Property)HEIGHT) + steps);
                entityIn.func_130014_f_().func_175656_a(blockPos, (BlockState)blockState.func_206870_a((Property)HEIGHT, (Comparable)Integer.valueOf(newHeight)));
                TileHelpers.getSafeTile((IBlockReader)worldIn, (BlockPos)blockPos, TileSqueezer.class).ifPresent(tile -> tile.setItemHeight(Math.max(newHeight, tile.getItemHeight())));
            }
        }
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block neighborBlock, BlockPos fromPos, boolean isMoving) {
        super.func_220069_a(state, worldIn, pos, neighborBlock, fromPos, isMoving);
        if (!worldIn.field_72995_K) {
            for (Direction enumfacing : Direction.values()) {
                if (!worldIn.func_175709_b(pos.func_177972_a(enumfacing), enumfacing)) continue;
                worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)HEIGHT, (Comparable)Integer.valueOf(1)));
                for (Entity entity : worldIn.func_217357_a(Entity.class, new AxisAlignedBB(pos, pos.func_177982_a(1, 1, 1)))) {
                    entity.func_213322_ci().func_72441_c(0.0, 0.25, 0.0);
                    entity.func_213293_j(0.0, 1.0, 0.0);
                }
                return;
            }
        }
    }

    public float getRelativeTopPositionTop(IBlockReader world, BlockPos blockPos, BlockState blockState) {
        return (float)(9 - (Integer)blockState.func_177229_b((Property)HEIGHT)) * 0.125f;
    }

    public VoxelShape func_220053_a(BlockState blockState, IBlockReader world, BlockPos blockPos, ISelectionContext selectionContext) {
        return SHAPES[(Integer)blockState.func_177229_b((Property)HEIGHT)];
    }

    public VoxelShape func_199600_g(BlockState blockState, IBlockReader world, BlockPos blockPos) {
        return SHAPES_BLOCK[(Integer)blockState.func_177229_b((Property)HEIGHT)];
    }

    public VoxelShape func_220071_b(BlockState blockState, IBlockReader world, BlockPos blockPos, ISelectionContext selectionContext) {
        return SHAPES_BLOCK[(Integer)blockState.func_177229_b((Property)HEIGHT)];
    }

    public boolean func_149740_M(BlockState blockState) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World world, BlockPos blockPos) {
        return (int)(((double)((Integer)blockState.func_177229_b((Property)HEIGHT)).intValue() - 1.0) / 6.0 * 15.0);
    }

    public void func_196243_a(BlockState oldState, World world, BlockPos blockPos, BlockState newState, boolean isMoving) {
        if (oldState.func_177230_c() != newState.func_177230_c()) {
            TileHelpers.getSafeTile((IBlockReader)world, (BlockPos)blockPos, TileSqueezer.class).ifPresent(tile -> {
                InventoryHelpers.dropItems((World)world, (IInventory)tile.getInventory(), (BlockPos)blockPos);
                world.func_175666_e(blockPos, oldState.func_177230_c());
            });
            super.func_196243_a(oldState, world, blockPos, newState, isMoving);
        }
    }
}

