/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.block;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.integrateddynamics.block.IEnergyContainerBlock;
import org.cyclops.integrateddynamics.core.block.BlockContainerCabled;
import org.cyclops.integrateddynamics.core.helper.Helpers;
import org.cyclops.integrateddynamics.tileentity.TileEnergyBattery;

public abstract class BlockEnergyBatteryBase
extends BlockContainerCabled
implements IEnergyContainerBlock {
    public BlockEnergyBatteryBase(AbstractBlock.Properties properties) {
        super(properties, TileEnergyBattery::new);
    }

    @Override
    public String getEneryContainerNBTName() {
        return "energy";
    }

    @Override
    public String getEneryContainerCapacityNBTName() {
        return "capacity";
    }

    public abstract boolean isCreative();

    @Override
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult blockRayTraceResult) {
        ActionResultType superActionResult = super.func_225533_a_(state, world, pos, player, hand, blockRayTraceResult);
        if (superActionResult.func_226246_a_()) {
            return superActionResult;
        }
        if (player.func_184586_b(hand).func_190926_b()) {
            return TileHelpers.getSafeTile((IBlockReader)world, (BlockPos)pos, TileEnergyBattery.class).map(tile -> {
                player.func_146105_b(Helpers.getLocalizedEnergyLevel(tile.getEnergyStored(), tile.getMaxEnergyStored()), true);
                return ActionResultType.SUCCESS;
            }).orElse(ActionResultType.PASS);
        }
        return ActionResultType.PASS;
    }

    public static void fill(IEnergyStorage energyStorage) {
        int max = energyStorage.getMaxEnergyStored();
        int stored = 1;
        while (stored > 0) {
            stored = energyStorage.receiveEnergy(max, false);
        }
    }

    @Override
    public void func_180633_a(World world, BlockPos blockPos, BlockState state, LivingEntity placer, ItemStack itemStack) {
        if (!world.func_201670_d()) {
            TileHelpers.getSafeTile((IBlockReader)world, (BlockPos)blockPos, TileEnergyBattery.class).ifPresent(tile -> BlockEnergyBatteryBase.itemStackToTile(itemStack.func_77946_l().func_77979_a(1), tile));
        }
        super.func_180633_a(world, blockPos, state, placer, itemStack);
    }

    public static void itemStackToTile(ItemStack itemStack, TileEnergyBattery tile) {
        itemStack.getCapability(CapabilityEnergy.ENERGY).ifPresent(energyStorage -> {
            tile.setEnergyStored(energyStorage.getEnergyStored());
            tile.setCapacity(energyStorage.getMaxEnergyStored());
        });
    }
}

