/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.api.part;

import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.api.network.INetworkEventListener;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.network.IPartNetworkElement;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartRenderPosition;
import org.cyclops.integrateddynamics.api.part.PartTarget;

public interface IPartType<P extends IPartType<P, S>, S extends IPartState<P>>
extends INetworkEventListener<IPartNetworkElement<P, S>> {
    public ResourceLocation getUniqueName();

    public String getTranslationKey();

    public ResourceLocation getBlockModelPath();

    public Item getItem();

    public boolean isSolid(S var1);

    public PartRenderPosition getPartRenderPosition();

    public void toNBT(CompoundNBT var1, S var2);

    public S fromNBT(CompoundNBT var1);

    public S getDefaultState();

    public void setUpdateInterval(S var1, int var2);

    public int getUpdateInterval(S var1);

    public int getMinimumUpdateInterval(S var1);

    @Deprecated
    public void setPriorityAndChannel(INetwork var1, IPartNetwork var2, PartTarget var3, S var4, int var5, int var6);

    public int getPriority(S var1);

    public int getChannel(S var1);

    public void setTargetSideOverride(S var1, @Nullable Direction var2);

    @Nullable
    public Direction getTargetSideOverride(S var1);

    public PartTarget getTarget(PartPos var1, S var2);

    public boolean isUpdate(S var1);

    public void update(INetwork var1, IPartNetwork var2, PartTarget var3, S var4);

    public void beforeNetworkKill(INetwork var1, IPartNetwork var2, PartTarget var3, S var4);

    public void afterNetworkAlive(INetwork var1, IPartNetwork var2, PartTarget var3, S var4);

    public void afterNetworkReAlive(INetwork var1, IPartNetwork var2, PartTarget var3, S var4);

    public ItemStack getItemStack(S var1, boolean var2);

    public ItemStack getPickBlock(World var1, BlockPos var2, S var3);

    public S getState(ItemStack var1);

    public void addDrops(PartTarget var1, S var2, List<ItemStack> var3, boolean var4, boolean var5);

    public void onNetworkAddition(INetwork var1, IPartNetwork var2, PartTarget var3, S var4);

    public void onNetworkRemoval(INetwork var1, IPartNetwork var2, PartTarget var3, S var4);

    public INetworkElement createNetworkElement(IPartContainer var1, DimPos var2, Direction var3);

    public ActionResultType onPartActivated(S var1, BlockPos var2, World var3, PlayerEntity var4, Hand var5, ItemStack var6, BlockRayTraceResult var7);

    public BlockState getBlockState(IPartContainer var1, Direction var2);

    public BlockState getBaseBlockState();

    public void updateTick(World var1, BlockPos var2, S var3, Random var4);

    public void onPreRemoved(INetwork var1, IPartNetwork var2, PartTarget var3, S var4);

    public void onPostRemoved(INetwork var1, IPartNetwork var2, PartTarget var3, S var4);

    public void onBlockNeighborChange(@Nullable INetwork var1, @Nullable IPartNetwork var2, PartTarget var3, S var4, IBlockReader var5, Block var6, BlockPos var7);

    public int getConsumptionRate(S var1);

    public void postUpdate(INetwork var1, IPartNetwork var2, PartTarget var3, S var4, boolean var5);

    public boolean isEnabled(S var1);

    public void setEnabled(S var1, boolean var2);

    public void loadTooltip(S var1, List<ITextComponent> var2);

    public void loadTooltip(ItemStack var1, List<ITextComponent> var2);

    public boolean shouldTriggerBlockRenderUpdate(@Nullable S var1, @Nullable S var2);

    public boolean forceLightTransparency(S var1);

    default public Optional<INamedContainerProvider> getContainerProvider(PartPos pos) {
        return Optional.empty();
    }

    default public void writeExtraGuiData(PacketBuffer packetBuffer, PartPos pos, ServerPlayerEntity player) {
    }

    default public Optional<INamedContainerProvider> getContainerProviderSettings(PartPos pos) {
        return Optional.empty();
    }

    default public void writeExtraGuiDataSettings(PacketBuffer packetBuffer, PartPos pos, ServerPlayerEntity player) {
    }
}

