/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.recipe;

import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.recipe.LaserDrillRarity;
import com.hrznstudio.titanium.recipe.serializer.GenericSerializer;
import com.hrznstudio.titanium.recipe.serializer.SerializableRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.common.crafting.conditions.ModLoadedCondition;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class LaserDrillFluidRecipe
extends SerializableRecipe {
    public static GenericSerializer<LaserDrillFluidRecipe> SERIALIZER = new GenericSerializer(new ResourceLocation("industrialforegoing", "laser_drill_fluid"), LaserDrillFluidRecipe.class);
    public static List<LaserDrillFluidRecipe> RECIPES = new ArrayList<LaserDrillFluidRecipe>();
    public static ResourceLocation EMPTY = new ResourceLocation("minecraft", "empty");
    public CompoundNBT output;
    public LaserDrillRarity[] rarity;
    public int pointer = 0;
    public Ingredient catalyst;
    public ResourceLocation entity;
    private String modIdCondition;

    public static void init() {
        new LaserDrillFluidRecipe(new FluidStack((Fluid)Fluids.field_204547_b, 100), 1, EMPTY, new LaserDrillRarity(LaserDrillRarity.NETHER, new RegistryKey[0], 5, 20, 8));
        new LaserDrillFluidRecipe(new FluidStack((Fluid)ModuleCore.ETHER.getSourceFluid(), 10), 10, new ResourceLocation("minecraft", "wither"), new LaserDrillRarity(new RegistryKey[0], new RegistryKey[0], 0, 256, 8));
        new LaserDrillFluidRecipe("oil", LaserDrillFluidRecipe.createNBT("pneumaticcraft:oil", 50), 15, EMPTY, new LaserDrillRarity(LaserDrillRarity.OIL, new RegistryKey[0], 20, 60, 8)).setModIdCondition("pneumaticcraft");
    }

    public LaserDrillFluidRecipe(String name, CompoundNBT output, Ingredient catalyst, ResourceLocation entity, LaserDrillRarity ... rarity) {
        super(new ResourceLocation("industrialforegoing", name));
        this.output = output;
        this.rarity = rarity;
        this.catalyst = catalyst;
        this.entity = entity;
        System.out.println(this.output);
        RECIPES.add(this);
    }

    public LaserDrillFluidRecipe(String name, CompoundNBT output, int color, ResourceLocation entity, LaserDrillRarity ... rarity) {
        this(name, output, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ModuleCore.LASER_LENS[color]}), entity, rarity);
    }

    public LaserDrillFluidRecipe(FluidStack output, int color, ResourceLocation entity, LaserDrillRarity ... rarity) {
        this(output.getFluid().getRegistryName().func_110623_a(), output.writeToNBT(new CompoundNBT()), color, entity, rarity);
    }

    public LaserDrillFluidRecipe(ResourceLocation resourceLocation) {
        super(resourceLocation);
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        return false;
    }

    public ItemStack func_77572_b(IInventory inv) {
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int width, int height) {
        return false;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public GenericSerializer<? extends SerializableRecipe> getSerializer() {
        return SERIALIZER;
    }

    public IRecipeType<?> func_222127_g() {
        return SERIALIZER.getRecipeType();
    }

    public Pair<ICondition, IConditionSerializer> getOutputCondition() {
        if (this.modIdCondition != null) {
            return Pair.of((Object)new ModLoadedCondition(this.modIdCondition), (Object)ModLoadedCondition.Serializer.INSTANCE);
        }
        return null;
    }

    public void setModIdCondition(String modIdCondition) {
        this.modIdCondition = modIdCondition;
    }

    public static CompoundNBT createNBT(String name, int amount) {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("FluidName", name);
        nbt.func_74768_a("Amount", amount);
        return nbt;
    }

    @Nullable
    public LaserDrillRarity getValidRarity(ResourceLocation biome, int height) {
        for (LaserDrillRarity laserDrillRarity : this.rarity) {
            if (laserDrillRarity.depth_max < height || laserDrillRarity.depth_min > height || !(laserDrillRarity.whitelist.length == 0 ? Arrays.stream(laserDrillRarity.blacklist).noneMatch(registryKey -> registryKey.func_240901_a_().equals((Object)biome)) : Arrays.stream(laserDrillRarity.whitelist).anyMatch(registryKey -> registryKey.func_240901_a_().equals((Object)biome)))) continue;
            return laserDrillRarity;
        }
        return null;
    }
}

