/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.gui.conveyor;

import com.buuz135.industrial.IndustrialForegoing;
import com.buuz135.industrial.api.conveyor.ConveyorUpgrade;
import com.buuz135.industrial.api.conveyor.gui.IGuiComponent;
import com.buuz135.industrial.gui.component.custom.FilterGuiComponent;
import com.buuz135.industrial.gui.component.custom.ICanSendNetworkMessage;
import com.buuz135.industrial.gui.conveyor.ContainerConveyor;
import com.buuz135.industrial.proxy.block.filter.IFilter;
import com.buuz135.industrial.proxy.network.ConveyorButtonInteractMessage;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class GuiConveyor
extends ContainerScreen<ContainerConveyor>
implements ICanSendNetworkMessage {
    public static final ResourceLocation BG_TEXTURE = new ResourceLocation("industrialforegoing", "textures/gui/conveyor.png");
    private ConveyorUpgrade upgrade = this.getContainer().getConveyor().getUpgradeMap().get(this.getContainer().getFacing());
    private List<IGuiComponent> componentList = new ArrayList<IGuiComponent>();
    private int x;
    private int y;
    private List<IFilter.GhostSlot> ghostSlots = new ArrayList<IFilter.GhostSlot>();

    public GuiConveyor(ContainerConveyor inventorySlotsIn, PlayerInventory inventory, ITextComponent component) {
        super((Container)inventorySlotsIn, inventory, component);
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.componentList.clear();
        this.upgrade.addComponentsToGui(this.componentList);
        for (IGuiComponent iGuiComponent : this.componentList) {
            if (!(iGuiComponent instanceof FilterGuiComponent)) continue;
            this.ghostSlots.addAll(Arrays.asList(((FilterGuiComponent)iGuiComponent).getFilter().getFilter()));
        }
    }

    protected void func_230450_a_(MatrixStack stack, float partialTicks, int mouseX, int mouseY) {
        this.func_230446_a_(stack);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.getMinecraft().func_110434_K().func_110577_a(BG_TEXTURE);
        this.x = (this.field_230708_k_ - this.field_146999_f) / 2;
        this.y = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.func_238474_b_(stack, this.x, this.y, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.upgrade != null) {
            String localized = new TranslationTextComponent(String.format("conveyor.upgrade.%s.%s", this.upgrade.getFactory().getRegistryName().func_110624_b(), this.upgrade.getFactory().getRegistryName().func_110623_a())).getString();
            this.getMinecraft().field_71466_p.func_238421_b_(stack, localized, (float)(this.x + this.field_146999_f / 2 - this.getMinecraft().field_71466_p.func_78256_a(localized) / 2), (float)(this.y + 6), 0x404040);
        }
        for (IGuiComponent iGuiComponent : this.componentList) {
            iGuiComponent.drawGuiBackgroundLayer(stack, this.x, this.y, mouseX, mouseY);
        }
    }

    protected void func_230451_b_(MatrixStack stack, int mouseX, int mouseY) {
        this.x = (this.field_230708_k_ - this.field_146999_f) / 2;
        this.y = (this.field_230709_l_ - this.field_147000_g) / 2;
        for (IGuiComponent iGuiComponent : this.componentList) {
            iGuiComponent.drawGuiForegroundLayer(stack, this.x, this.y, mouseX, mouseY);
        }
        this.func_230459_a_(stack, mouseX - this.x, mouseY - this.y);
        for (IGuiComponent iGuiComponent : this.componentList) {
            List<ITextComponent> tooltips;
            if (!iGuiComponent.isInside(mouseX - this.x, mouseY - this.y) || (tooltips = iGuiComponent.getTooltip(this.x, this.y, mouseX, mouseY)) == null) continue;
            this.func_243308_b(stack, tooltips, mouseX - this.x, mouseY - this.y);
        }
    }

    public ContainerConveyor getContainer() {
        return (ContainerConveyor)super.func_212873_a_();
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        boolean click = super.func_231044_a_(mouseX, mouseY, mouseButton);
        for (IGuiComponent iGuiComponent : this.componentList) {
            if (!iGuiComponent.isInside(mouseX - (double)this.x, mouseY - (double)this.y) || !iGuiComponent.handleClick(this, this.x, this.y, mouseX, mouseY)) continue;
            return true;
        }
        return click;
    }

    @Override
    public void sendMessage(int id, CompoundNBT compound) {
        IndustrialForegoing.NETWORK.get().sendToServer((Object)new ConveyorButtonInteractMessage(this.upgrade.getPos(), id, this.upgrade.getSide(), compound));
    }

    public List<IFilter.GhostSlot> getGhostSlots() {
        return this.ghostSlots;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }
}

