/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.transportstorage.transporter;

import com.buuz135.industrial.api.IBlockContainer;
import com.buuz135.industrial.api.transporter.FilteredTransporterType;
import com.buuz135.industrial.api.transporter.TransporterType;
import com.buuz135.industrial.api.transporter.TransporterTypeFactory;
import com.buuz135.industrial.block.transportstorage.tile.TransporterTile;
import com.buuz135.industrial.proxy.block.filter.IFilter;
import com.buuz135.industrial.proxy.block.filter.RegulatorFilter;
import com.buuz135.industrial.utils.IndustrialTags;
import com.google.common.collect.Sets;
import com.hrznstudio.titanium.recipe.generator.TitaniumShapedRecipeBuilder;
import com.hrznstudio.titanium.util.TileUtil;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.Tags;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TransporterWorldType
extends FilteredTransporterType<ItemStack, IItemHandler> {
    private int extractSlot = 0;

    public TransporterWorldType(IBlockContainer container, TransporterTypeFactory factory, Direction side, TransporterTypeFactory.TransporterAction action) {
        super(container, factory, side, action);
    }

    @Override
    public RegulatorFilter<ItemStack, IItemHandler> createFilter() {
        return new RegulatorFilter<ItemStack, IItemHandler>(20, 20, 5, 3, 16, 64, 8192, ""){

            @Override
            public int matches(ItemStack stack, IItemHandler itemHandler, boolean isRegulated) {
                if (this.isEmpty()) {
                    return stack.func_190916_E();
                }
                int amount = 0;
                if (isRegulated) {
                    for (int i = 0; i < itemHandler.getSlots(); ++i) {
                        if (!itemHandler.getStackInSlot(i).func_77969_a(stack)) continue;
                        amount += itemHandler.getStackInSlot(i).func_190916_E();
                    }
                }
                for (IFilter.GhostSlot slot : this.getFilter()) {
                    if (!stack.func_77969_a(slot.getStack())) continue;
                    int maxAmount = isRegulated ? slot.getAmount() : Integer.MAX_VALUE;
                    int returnAmount = Math.min(stack.func_190916_E(), maxAmount - amount);
                    if (returnAmount <= 0) continue;
                    return returnAmount;
                }
                return 0;
            }
        };
    }

    @Override
    public void update() {
        super.update();
        float speed = this.getSpeed();
        if (!this.getWorld().field_72995_K && (float)this.getWorld().func_82737_E() % Math.max(1.0f, 4.0f - speed) == 0.0f) {
            IBlockContainer container = this.getContainer();
            if (this.getAction() == TransporterTypeFactory.TransporterAction.EXTRACT && container instanceof TransporterTile) {
                TileUtil.getTileEntity((IBlockReader)this.getWorld(), (BlockPos)this.getPos().func_177972_a(this.getSide())).ifPresent(tileEntity -> tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.getSide().func_176734_d()).ifPresent(origin -> {
                    if (origin.getStackInSlot(this.extractSlot).func_190926_b() || !this.filter(this.getFilter(), this.isWhitelist(), origin.getStackInSlot(this.extractSlot), (IItemHandler)origin, false)) {
                        this.findSlot((IItemHandler)origin);
                    }
                    if (!origin.getStackInSlot(this.extractSlot).func_190926_b() && this.filter(this.getFilter(), this.isWhitelist(), origin.getStackInSlot(this.extractSlot), (IItemHandler)origin, false)) {
                        int amount = (int)(1.0f * this.getEfficiency());
                        ItemStack extracted = origin.extractItem(this.extractSlot, amount, false);
                        if (extracted.func_190926_b()) {
                            return;
                        }
                        ItemEntity item = new ItemEntity(this.getWorld(), (double)this.getPos().func_177958_n() + 0.5, (double)this.getPos().func_177956_o() + 0.2, (double)this.getPos().func_177952_p() + 0.5);
                        item.func_213293_j(0.0, 0.0, 0.0);
                        item.func_174867_a(4);
                        item.func_92058_a(extracted);
                        this.getWorld().func_217376_c((Entity)item);
                    }
                }));
            }
            if (this.getAction() == TransporterTypeFactory.TransporterAction.INSERT && container instanceof TransporterTile) {
                TileUtil.getTileEntity((IBlockReader)this.getWorld(), (BlockPos)this.getPos().func_177972_a(this.getSide())).ifPresent(tileEntity -> tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.getSide().func_176734_d()).ifPresent(origin -> {
                    for (ItemEntity item : this.getWorld().func_217357_a(ItemEntity.class, new AxisAlignedBB((double)this.getPos().func_177958_n(), (double)this.getPos().func_177956_o(), (double)this.getPos().func_177952_p(), (double)(this.getPos().func_177958_n() + 1), (double)(this.getPos().func_177956_o() + 1), (double)(this.getPos().func_177952_p() + 1)))) {
                        int i;
                        if (!item.func_70089_S()) continue;
                        ItemStack stack = item.func_92059_d().func_77946_l();
                        int amount = Math.min(stack.func_190916_E(), (int)(1.0f * this.getEfficiency()));
                        stack.func_190920_e(amount);
                        amount = this.getFilter().matches(stack, (IItemHandler)origin, this.isRegulated());
                        if (amount <= 0) continue;
                        stack.func_190920_e(amount);
                        if (stack.func_190926_b() || !this.filter(this.getFilter(), this.isWhitelist(), stack, (IItemHandler)origin, this.isRegulated()) || (i = 0) >= origin.getSlots()) continue;
                        stack = origin.insertItem(i, stack, false);
                        ItemStack originStack = item.func_92059_d().func_77946_l();
                        originStack.func_190918_g(amount - stack.func_190916_E());
                        if (originStack.func_190926_b()) {
                            item.func_92058_a(ItemStack.field_190927_a);
                            item.func_70106_y();
                            return;
                        }
                        item.func_92058_a(originStack);
                        return;
                    }
                }));
            }
        }
    }

    private void findSlot(IItemHandler itemHandler) {
        for (int i = this.extractSlot; i < itemHandler.getSlots(); ++i) {
            if (itemHandler.getStackInSlot(i).func_190926_b() || !this.filter(this.getFilter(), this.isWhitelist(), itemHandler.getStackInSlot(i), itemHandler, false)) continue;
            this.extractSlot = i;
            return;
        }
        this.extractSlot = 0;
    }

    private boolean filter(RegulatorFilter<ItemStack, IItemHandler> filter, boolean whitelist, ItemStack stack, IItemHandler handler, boolean isRegulated) {
        int accepts = filter.matches(stack, handler, isRegulated);
        if (whitelist && filter.isEmpty()) {
            return false;
        }
        return filter.isEmpty() != (whitelist == accepts > 0);
    }

    @Override
    public void updateClient() {
        super.updateClient();
    }

    @Override
    public void handleRenderSync(Direction origin, CompoundNBT compoundNBT) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderTransfer(Vector3f pos, Direction direction, int step, MatrixStack stack, int combinedOverlayIn, IRenderTypeBuffer buffer) {
        super.renderTransfer(pos, direction, step, stack, combinedOverlayIn, buffer);
    }

    public static class Factory
    extends TransporterTypeFactory {
        public Factory() {
            this.setRegistryName("world");
        }

        @Override
        public TransporterType create(IBlockContainer container, Direction face, TransporterTypeFactory.TransporterAction action) {
            return new TransporterWorldType(container, this, face, action);
        }

        @Override
        @Nonnull
        public ResourceLocation getModel(Direction upgradeSide, TransporterTypeFactory.TransporterAction action) {
            return new ResourceLocation("industrialforegoing", "block/transporters/world_transporter_" + action.name().toLowerCase() + "_" + upgradeSide.func_176610_l().toLowerCase());
        }

        @Override
        public Set<ResourceLocation> getTextures() {
            return Sets.newHashSet((Object[])new ResourceLocation[]{new ResourceLocation("industrialforegoing:blocks/transporters/world"), new ResourceLocation("industrialforegoing:blocks/base/bottom")});
        }

        @Override
        public boolean canBeAttachedAgainst(World world, BlockPos pos, Direction face) {
            return TileUtil.getTileEntity((IBlockReader)world, (BlockPos)pos).map(tileEntity -> tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face).isPresent()).orElse(false);
        }

        @Override
        @Nonnull
        public ResourceLocation getItemModel() {
            return new ResourceLocation("industrialforegoing", "block/transporters/world_transporter_" + TransporterTypeFactory.TransporterAction.EXTRACT.name().toLowerCase() + "_" + Direction.NORTH.func_176610_l().toLowerCase());
        }

        public void registerRecipe(Consumer<IFinishedRecipe> consumer) {
            TitaniumShapedRecipeBuilder.shapedRecipe((IItemProvider)this.getUpgradeItem(), (int)2).func_200472_a("IPI").func_200472_a("GMG").func_200472_a("ICI").func_200469_a(Character.valueOf('I'), (ITag)Tags.Items.DUSTS_REDSTONE).func_200462_a(Character.valueOf('P'), (IItemProvider)Items.field_151079_bi).func_200462_a(Character.valueOf('G'), (IItemProvider)Items.field_221862_eo).func_200469_a(Character.valueOf('M'), IndustrialTags.Items.MACHINE_FRAME_PITY).func_200462_a(Character.valueOf('C'), (IItemProvider)Items.field_221874_eu).func_200464_a(consumer);
        }
    }
}

