/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.transportstorage.tile;

import com.buuz135.industrial.api.IBlockContainer;
import com.buuz135.industrial.api.transporter.TransporterType;
import com.buuz135.industrial.api.transporter.TransporterTypeFactory;
import com.buuz135.industrial.gui.transporter.ContainerTransporter;
import com.buuz135.industrial.module.ModuleTransportStorage;
import com.buuz135.industrial.proxy.client.model.TransporterModelData;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.tile.ActiveTile;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.fml.network.NetworkHooks;

public class TransporterTile
extends ActiveTile<TransporterTile>
implements IBlockContainer<TransporterTypeFactory> {
    private Map<Direction, TransporterType> transporterTypeMap = new HashMap<Direction, TransporterType>();

    public TransporterTile() {
        super((BasicTileBlock)ModuleTransportStorage.TRANSPORTER);
    }

    @Nonnull
    public TransporterTile getSelf() {
        return this;
    }

    @Override
    public World getBlockWorld() {
        return this.field_145850_b;
    }

    @Override
    public BlockPos getBlockPosition() {
        return this.field_174879_c;
    }

    @Override
    public void requestSync() {
        this.markForUpdate();
    }

    @Override
    public void requestFluidSync() {
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (this.isServer()) {
            this.getTransporterTypeMap().values().forEach(TransporterType::update);
        }
        if (this.isClient()) {
            this.getTransporterTypeMap().values().forEach(TransporterType::updateClient);
        }
    }

    @Override
    public boolean hasUpgrade(Direction facing) {
        return this.transporterTypeMap.containsKey(facing);
    }

    @Override
    public void addUpgrade(Direction facing, TransporterTypeFactory factory) {
        if (!this.hasUpgrade(facing)) {
            this.transporterTypeMap.put(facing, factory.create(this, facing, TransporterTypeFactory.TransporterAction.EXTRACT));
            this.requestSync();
            if (this.field_145850_b.field_72995_K) {
                ModelDataManager.requestModelDataRefresh((TileEntity)this);
            }
        }
    }

    @Override
    public void removeUpgrade(Direction facing, boolean drop) {
        if (this.hasUpgrade(facing)) {
            if (!this.field_145850_b.field_72995_K && drop) {
                TransporterType upgrade = this.transporterTypeMap.get(facing);
                for (ItemStack stack : upgrade.getDrops()) {
                    ItemEntity item = new ItemEntity(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5);
                    item.func_92058_a(stack);
                    this.field_145850_b.func_217376_c((Entity)item);
                }
            }
            this.transporterTypeMap.get(facing).onUpgradeRemoved();
            this.transporterTypeMap.remove(facing);
            this.requestSync();
            if (this.field_145850_b.field_72995_K) {
                ModelDataManager.requestModelDataRefresh((TileEntity)this);
            }
        }
        if (this.transporterTypeMap.isEmpty()) {
            this.field_145850_b.func_175656_a(this.field_174879_c, Blocks.field_150350_a.func_176223_P());
        }
    }

    public void openGui(PlayerEntity player, Direction facing) {
        if (player instanceof ServerPlayerEntity) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this, packetBuffer -> {
                packetBuffer.func_179255_a(this.field_174879_c);
                packetBuffer.func_179249_a((Enum)facing);
            });
        }
    }

    @Nullable
    public Container createMenu(int menu, PlayerInventory inventoryPlayer, PlayerEntity entityPlayer) {
        return new ContainerTransporter(menu, this, (Direction)ModuleTransportStorage.TRANSPORTER.getFacingUpgradeHit(this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b, this.field_174879_c, entityPlayer).getLeft(), inventoryPlayer);
    }

    @Override
    public List<Integer> getEntityFilter() {
        return Collections.emptyList();
    }

    @Nonnull
    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(TransporterModelData.UPGRADE_PROPERTY, (Object)new TransporterModelData(new HashMap<Direction, TransporterType>(this.transporterTypeMap))).build();
    }

    public Map<Direction, TransporterType> getTransporterTypeMap() {
        return this.transporterTypeMap;
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound = super.func_189515_b(compound);
        CompoundNBT upgrades = new CompoundNBT();
        for (Direction facing : Direction.values()) {
            if (!this.hasUpgrade(facing)) continue;
            CompoundNBT upgradeTag = new CompoundNBT();
            TransporterType upgrade = this.getTransporterTypeMap().get(facing);
            upgradeTag.func_74778_a("factory", upgrade.getFactory().getRegistryName().toString());
            CompoundNBT customNBT = upgrade.serializeNBT();
            if (customNBT != null) {
                upgradeTag.func_218657_a("customNBT", (INBT)customNBT);
            }
            upgrades.func_218657_a(facing.func_176610_l(), (INBT)upgradeTag);
        }
        compound.func_218657_a("Transporters", (INBT)upgrades);
        return compound;
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        if (compound.func_74764_b("Transporters")) {
            CompoundNBT upgradesTag = compound.func_74775_l("Transporters");
            for (Direction facing : Direction.values()) {
                if (!upgradesTag.func_74764_b(facing.func_176610_l())) continue;
                CompoundNBT upgradeTag = upgradesTag.func_74775_l(facing.func_176610_l());
                TransporterTypeFactory factory = null;
                for (TransporterTypeFactory transporterTypeFactory : TransporterTypeFactory.FACTORIES) {
                    if (!transporterTypeFactory.getRegistryName().equals((Object)new ResourceLocation(upgradeTag.func_74779_i("factory")))) continue;
                    factory = transporterTypeFactory;
                    break;
                }
                if (factory == null) continue;
                TransporterType upgrade = this.transporterTypeMap.getOrDefault(facing, factory.create(this, facing, TransporterTypeFactory.TransporterAction.EXTRACT));
                if (upgradeTag.func_150297_b("customNBT", 10)) {
                    upgrade.deserializeNBT(upgradeTag.func_74775_l("customNBT"));
                }
                this.transporterTypeMap.put(facing, upgrade);
            }
        }
    }
}

