/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.resourceproduction.tile;

import com.buuz135.industrial.block.resourceproduction.tile.ILaserBase;
import com.buuz135.industrial.block.tile.IndustrialMachineTile;
import com.buuz135.industrial.config.machine.resourceproduction.OreLaserBaseConfig;
import com.buuz135.industrial.module.ModuleResourceProduction;
import com.buuz135.industrial.recipe.LaserDrillOreRecipe;
import com.buuz135.industrial.utils.ItemStackUtils;
import com.buuz135.industrial.utils.ItemStackWeightedItem;
import com.hrznstudio.titanium._impl.TagConfig;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.augment.AugmentTypes;
import com.hrznstudio.titanium.api.augment.IAugmentType;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.ProgressBarScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.TextScreenAddon;
import com.hrznstudio.titanium.component.button.ArrowButtonComponent;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import com.hrznstudio.titanium.component.progress.ProgressBarComponent;
import com.hrznstudio.titanium.component.sideness.IFacingComponent;
import com.hrznstudio.titanium.item.AugmentWrapper;
import com.hrznstudio.titanium.util.FacingUtil;
import com.hrznstudio.titanium.util.RecipeUtil;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemHandlerHelper;

public class OreLaserBaseTile
extends IndustrialMachineTile<OreLaserBaseTile>
implements ILaserBase<OreLaserBaseTile> {
    @Save
    private ProgressBarComponent<OreLaserBaseTile> work;
    @Save
    private SidedInventoryComponent<OreLaserBaseTile> lens;
    @Save
    private SidedInventoryComponent<OreLaserBaseTile> output;
    @Save
    private int miningDepth;

    public OreLaserBaseTile() {
        super(ModuleResourceProduction.ORE_LASER_BASE);
        this.setShowEnergy(false);
        this.miningDepth = this.func_174877_v().func_177956_o();
        this.work = new ProgressBarComponent<OreLaserBaseTile>(12, 22, 0, OreLaserBaseConfig.maxProgress){

            public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
                return Collections.singletonList(() -> new ProgressBarScreenAddon<OreLaserBaseTile>(OreLaserBaseTile.this.work.getPosX(), OreLaserBaseTile.this.work.getPosY(), (ProgressBarComponent)this){

                    public List<ITextComponent> getTooltipLines() {
                        ArrayList<ITextComponent> tooltip = new ArrayList<ITextComponent>();
                        tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GOLD + new TranslationTextComponent("tooltip.titanium.progressbar.progress").getString() + TextFormatting.WHITE + new DecimalFormat().format(OreLaserBaseTile.this.work.getProgress()) + TextFormatting.GOLD + "/" + TextFormatting.WHITE + new DecimalFormat().format(OreLaserBaseTile.this.work.getMaxProgress())));
                        return tooltip;
                    }
                });
            }
        }.setColor(DyeColor.YELLOW).setCanIncrease(oreLaserBaseTile -> true).setProgressIncrease(0).setCanReset(oreLaserBaseTile -> true).setOnStart(() -> {
            int maxProgress = (int)Math.floor((float)OreLaserBaseConfig.maxProgress * (this.hasAugmentInstalled(AugmentTypes.EFFICIENCY) ? AugmentWrapper.getType((ItemStack)((ItemStack)this.getInstalledAugments(AugmentTypes.EFFICIENCY).get(0)), (IAugmentType)AugmentTypes.EFFICIENCY) : 1.0f));
            this.work.setMaxProgress(maxProgress);
        }).setOnFinishWork(this::onWork);
        this.addProgressBar(this.work);
        this.lens = (SidedInventoryComponent)new SidedInventoryComponent("lens", 30, 24, 6, 0).setColor(DyeColor.BLUE).setRange(2, 3).setSlotLimit(1);
        this.addInventory((InventoryComponent)this.lens);
        this.lens.getFacingModes().keySet().forEach(sideness -> this.lens.getFacingModes().put(sideness, IFacingComponent.FaceMode.NONE));
        this.output = (SidedInventoryComponent)new SidedInventoryComponent("output", 74, 24, 15, 1).setColor(DyeColor.ORANGE).setRange(5, 3).setInputFilter((stack, integer) -> false);
        this.addInventory((InventoryComponent)this.output);
        int y = 84;
        this.addButton(new ArrowButtonComponent(53, y, 14, 14, FacingUtil.Sideness.LEFT).setPredicate((playerEntity, compoundNBT) -> {
            this.miningDepth = Math.max(0, this.miningDepth - 1);
            this.markForUpdate();
        }));
        this.addButton(new ArrowButtonComponent(126, y, 14, 14, FacingUtil.Sideness.RIGHT).setPredicate((playerEntity, compoundNBT) -> {
            this.miningDepth = Math.min(255, this.miningDepth + 1);
            this.markForUpdate();
        }));
        this.addGuiAddonFactory(() -> new TextScreenAddon("", 70, y + 3, false){

            public String getText() {
                return TextFormatting.DARK_GRAY + new TranslationTextComponent("text.industrialforegoing.depth").getString() + OreLaserBaseTile.this.miningDepth;
            }
        });
    }

    public void func_226984_a_(World world, BlockPos pos) {
        super.func_226984_a_(world, pos);
        if (this.miningDepth == 0) {
            this.miningDepth = this.field_174879_c.func_177956_o();
        }
    }

    private void onWork() {
        List items;
        if (!ItemStackUtils.isInventoryFull(this.output) && !(items = RecipeUtil.getRecipes((World)this.field_145850_b, (IRecipeType)LaserDrillOreRecipe.SERIALIZER.getRecipeType()).stream().filter(laserDrillOreRecipe -> laserDrillOreRecipe.getValidRarity(this.field_145850_b.func_226691_t_(this.field_174879_c).getRegistryName(), this.miningDepth) != null).map(laserDrillOreRecipe -> {
            int weight = laserDrillOreRecipe.getValidRarity((ResourceLocation)this.field_145850_b.func_226691_t_((BlockPos)this.field_174879_c).getRegistryName(), (int)this.miningDepth).weight;
            for (int i = 0; i < this.lens.getSlots(); ++i) {
                if (!laserDrillOreRecipe.catalyst.test(this.lens.getStackInSlot(i))) continue;
                weight += OreLaserBaseConfig.catalystModifier;
            }
            ItemStack stack = laserDrillOreRecipe.output.func_193365_a()[0];
            block1: for (String modid : TagConfig.ITEM_PREFERENCE) {
                for (ItemStack matchingStack : laserDrillOreRecipe.output.func_193365_a()) {
                    if (!matchingStack.func_77973_b().getRegistryName().func_110624_b().equals(modid)) continue;
                    stack = matchingStack;
                    continue block1;
                }
            }
            return new ItemStackWeightedItem(stack.func_77946_l(), weight);
        }).collect(Collectors.toList())).isEmpty()) {
            ItemStack stack = ((ItemStackWeightedItem)WeightedRandom.func_76271_a((Random)this.field_145850_b.func_201674_k(), items)).getStack();
            ItemHandlerHelper.insertItem(this.output, (ItemStack)stack, (boolean)false);
        }
    }

    public OreLaserBaseTile getSelf() {
        return this;
    }

    protected EnergyStorageComponent<OreLaserBaseTile> createEnergyStorage() {
        return new EnergyStorageComponent(0, 4, 10);
    }

    @Override
    public ProgressBarComponent<OreLaserBaseTile> getBar() {
        return this.work;
    }

    @Override
    public boolean canAcceptAugment(ItemStack augment) {
        if (AugmentWrapper.hasType((ItemStack)augment, (IAugmentType)AugmentTypes.SPEED)) {
            return false;
        }
        return super.canAcceptAugment(augment);
    }
}

