/*
 * Decompiled with CFR 0.152.
 */
package mcjty.incontrol.tools.varia;

import com.google.gson.JsonObject;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.incontrol.ErrorHandler;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Logger;

public class Tools {
    public static RegistryKey<World> getDimensionKey(IWorld world) {
        if (world instanceof World) {
            return ((World)world).func_234923_W_();
        }
        if (world instanceof IServerWorld) {
            return ((IServerWorld)world).func_201672_e().func_234923_W_();
        }
        throw new IllegalStateException("Not possible to get a dimension key here!");
    }

    @Nonnull
    public static String getBiomeId(Biome biome) {
        if (biome.getRegistryName() == null) {
            Optional biomeRegistry = DynamicRegistries.func_239770_b_().func_230521_a_(Registry.field_239720_u_);
            return biomeRegistry.map(r -> r.func_230519_c_((Object)biome).map(key -> key.func_240901_a_().toString()).orElse("")).orElse("");
        }
        return biome.getRegistryName().toString();
    }

    public static Pair<Float, ItemStack> parseStackWithFactor(String name, Logger logger) {
        int i;
        for (i = 0; i < name.length() && (Character.isDigit(name.charAt(i)) || name.charAt(i) == '.'); ++i) {
        }
        if (i < name.length() && name.charAt(i) == '=') {
            float v;
            String f = name.substring(0, i);
            try {
                v = Float.parseFloat(f);
            }
            catch (NumberFormatException e) {
                v = 1.0f;
            }
            return Pair.of((Object)Float.valueOf(v), (Object)Tools.parseStack(name.substring(i + 1), logger));
        }
        return Pair.of((Object)Float.valueOf(1.0f), (Object)Tools.parseStack(name, logger));
    }

    public static Pair<Float, ItemStack> parseStackWithFactor(JsonObject obj, Logger logger) {
        ItemStack stack;
        float factor = 1.0f;
        if (obj.has("factor")) {
            factor = obj.get("factor").getAsFloat();
        }
        if ((stack = Tools.parseStack(obj, logger)) == null) {
            return null;
        }
        return Pair.of((Object)Float.valueOf(factor), (Object)stack);
    }

    @Nonnull
    public static ItemStack parseStack(String name, Logger logger) {
        if (name.contains("/")) {
            CompoundNBT nbt;
            String[] split = StringUtils.split((String)name, (String)"/");
            ItemStack stack = Tools.parseStackNoNBT(split[0], logger);
            if (stack.func_190926_b()) {
                return stack;
            }
            try {
                nbt = JsonToNBT.func_180713_a((String)split[1]);
            }
            catch (CommandSyntaxException e) {
                ErrorHandler.error("Error parsing NBT in '" + name + "'!");
                return ItemStack.field_190927_a;
            }
            stack.func_77982_d(nbt);
            return stack;
        }
        return Tools.parseStackNoNBT(name, logger);
    }

    @Nullable
    public static ItemStack parseStack(JsonObject obj, Logger logger) {
        if (obj.has("empty")) {
            return ItemStack.field_190927_a;
        }
        String name = obj.get("item").getAsString();
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(name));
        if (item == null) {
            ErrorHandler.error("Unknown item '" + name + "'!");
            return null;
        }
        ItemStack stack = new ItemStack((IItemProvider)item);
        if (obj.has("damage")) {
            stack.func_196085_b(obj.get("damage").getAsInt());
        }
        if (obj.has("count")) {
            stack.func_190920_e(obj.get("count").getAsInt());
        }
        if (obj.has("nbt")) {
            String nbt = obj.get("nbt").toString();
            CompoundNBT tag = null;
            try {
                tag = JsonToNBT.func_180713_a((String)nbt);
            }
            catch (CommandSyntaxException e) {
                ErrorHandler.error("Error parsing json '" + nbt + "'!");
                return ItemStack.field_190927_a;
            }
            stack.func_77982_d(tag);
        }
        return stack;
    }

    private static ItemStack parseStackNoNBT(String name, Logger logger) {
        if (name.contains("@")) {
            String[] split = StringUtils.split((String)name, (String)"@");
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(split[0]));
            if (item == null) {
                return ItemStack.field_190927_a;
            }
            int meta = 0;
            try {
                meta = Integer.parseInt(split[1]);
            }
            catch (NumberFormatException e) {
                ErrorHandler.error("Unknown item '" + name + "'!");
                return ItemStack.field_190927_a;
            }
            return new ItemStack((IItemProvider)item, 1);
        }
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(name));
        if (item == null) {
            return ItemStack.field_190927_a;
        }
        return new ItemStack((IItemProvider)item);
    }

    public static ServerWorld getServerWorld(IWorld world) {
        ServerWorld sw;
        if (world instanceof ServerWorld) {
            sw = (ServerWorld)world;
        } else if (world instanceof IServerWorld) {
            sw = ((IServerWorld)world).func_201672_e();
        } else {
            throw new IllegalStateException("No world found!");
        }
        return sw;
    }
}

