/*
 * Decompiled with CFR 0.152.
 */
package mcjty.incontrol.spawner;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import mcjty.incontrol.ErrorHandler;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;

public class SpawnerConditions {
    private final Set<RegistryKey<World>> dimensions;
    private final int mindist;
    private final int maxdist;
    private final int minheight;
    private final int maxheight;
    private final int mindaycount;
    private final int maxdaycount;
    private final boolean inLiquid;
    private final boolean inWater;
    private final boolean inLava;
    private final boolean inAir;
    private final boolean noRestrictions;
    private final int maxthis;
    private final int maxlocal;
    private final int maxtotal;
    private final int maxhostile;
    private final int maxpeaceful;
    private final int maxneutral;
    public static final SpawnerConditions DEFAULT = SpawnerConditions.create().build();
    private static final Map<String, Cmd> CONDITIONS = new HashMap<String, Cmd>();

    private SpawnerConditions(Builder builder) {
        this.dimensions = new HashSet<RegistryKey<World>>(builder.dimensions);
        this.mindist = builder.mindist;
        this.maxdist = builder.maxdist;
        this.minheight = builder.minheight;
        this.maxheight = builder.maxheight;
        this.mindaycount = builder.mindaycount;
        this.maxdaycount = builder.maxdaycount;
        this.inLiquid = builder.inLiquid;
        this.inWater = builder.inWater;
        this.inLava = builder.inLava;
        this.inAir = builder.inAir;
        this.maxthis = builder.maxthis;
        this.maxlocal = builder.maxlocal;
        this.maxtotal = builder.maxtotal;
        this.maxhostile = builder.maxhostile;
        this.maxpeaceful = builder.maxpeaceful;
        this.maxneutral = builder.maxneutral;
        this.noRestrictions = builder.noRestrictions;
        this.validate();
    }

    private void validate() {
        if (this.mindaycount < 0) {
            throw new IllegalStateException("Invalid negative minimum daycount!");
        }
        if (this.maxdaycount < 0) {
            throw new IllegalStateException("Invalid negative maximum daycount!");
        }
        if (this.mindist < 0) {
            throw new IllegalStateException("Invalid negative minimum distance!");
        }
        if (this.maxdist < 0) {
            throw new IllegalStateException("Invalid negative maximum distance!");
        }
        if (this.minheight < 0) {
            throw new IllegalStateException("Invalid negative minimum height!");
        }
        if (this.maxheight < 0) {
            throw new IllegalStateException("Invalid negative maximum height!");
        }
        if (this.mindist >= this.maxdist) {
            throw new IllegalStateException("Minimum distance must be smaller then maximum!");
        }
        if (this.minheight >= this.maxheight) {
            throw new IllegalStateException("Minimum height must be smaller then maximum!");
        }
    }

    public Set<RegistryKey<World>> getDimensions() {
        return this.dimensions;
    }

    public int getMindaycount() {
        return this.mindaycount;
    }

    public int getMaxdaycount() {
        return this.maxdaycount;
    }

    public int getMindist() {
        return this.mindist;
    }

    public int getMaxdist() {
        return this.maxdist;
    }

    public int getMinheight() {
        return this.minheight;
    }

    public int getMaxheight() {
        return this.maxheight;
    }

    public boolean isInLiquid() {
        return this.inLiquid;
    }

    public boolean isInWater() {
        return this.inWater;
    }

    public boolean isInLava() {
        return this.inLava;
    }

    public boolean isInAir() {
        return this.inAir;
    }

    public boolean isNoRestrictions() {
        return this.noRestrictions;
    }

    public int getMaxthis() {
        return this.maxthis;
    }

    public int getMaxlocal() {
        return this.maxlocal;
    }

    public int getMaxtotal() {
        return this.maxtotal;
    }

    public int getMaxhostile() {
        return this.maxhostile;
    }

    public int getMaxpeaceful() {
        return this.maxpeaceful;
    }

    public int getMaxneutral() {
        return this.maxneutral;
    }

    public static Builder create() {
        return new Builder();
    }

    public static void parse(JsonObject object, Builder builder) {
        block20: for (Map.Entry entry : object.entrySet()) {
            String attr = (String)entry.getKey();
            Cmd cmd = CONDITIONS.get(attr);
            if (cmd == null) {
                ErrorHandler.error("Invalid condition '" + attr + "' for spawner rule!");
                return;
            }
            switch (cmd) {
                case DIMENSION: {
                    JsonElement value = object.get(attr);
                    if (value.isJsonArray()) {
                        for (JsonElement element : value.getAsJsonArray()) {
                            RegistryKey key = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(element.getAsString()));
                            builder.dimensions(key);
                        }
                        continue block20;
                    }
                    RegistryKey key = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(value.getAsString()));
                    builder.dimensions(key);
                    break;
                }
                case MINDIST: {
                    builder.distance(object.getAsJsonPrimitive("mindist").getAsInt(), builder.maxdist);
                    break;
                }
                case MAXDIST: {
                    builder.distance(builder.mindist, object.getAsJsonPrimitive("maxdist").getAsInt());
                    break;
                }
                case MINDAYCOUNT: {
                    builder.daycount(object.getAsJsonPrimitive("mindaycount").getAsInt(), builder.maxdaycount);
                    break;
                }
                case MAXDAYCOUNT: {
                    builder.daycount(builder.mindaycount, object.getAsJsonPrimitive("maxdaycount").getAsInt());
                    break;
                }
                case MINHEIGHT: {
                    builder.height(object.getAsJsonPrimitive("minheight").getAsInt(), builder.maxheight);
                    break;
                }
                case MAXHEIGHT: {
                    builder.height(builder.minheight, object.getAsJsonPrimitive("maxheight").getAsInt());
                    break;
                }
                case INWATER: {
                    builder.inWater(object.getAsJsonPrimitive("inwater").getAsBoolean());
                    break;
                }
                case INLAVA: {
                    builder.inLava(object.getAsJsonPrimitive("inlava").getAsBoolean());
                    break;
                }
                case INLIQUID: {
                    builder.inLiquid(object.getAsJsonPrimitive("inliquid").getAsBoolean());
                    break;
                }
                case INAIR: {
                    builder.inAir(object.getAsJsonPrimitive("inair").getAsBoolean());
                    break;
                }
                case NORESTRICTIONS: {
                    builder.noRestrictions(object.getAsJsonPrimitive("norestrictions").getAsBoolean());
                    break;
                }
                case MAXTHIS: {
                    builder.maxThis(object.getAsJsonPrimitive("maxthis").getAsInt());
                    break;
                }
                case MAXLOCAL: {
                    builder.maxLocal(object.getAsJsonPrimitive("maxlocal").getAsInt());
                    break;
                }
                case MAXTOTAL: {
                    builder.maxTotal(object.getAsJsonPrimitive("maxtotal").getAsInt());
                    break;
                }
                case MAXHOSTILE: {
                    builder.maxHostile(object.getAsJsonPrimitive("maxhostile").getAsInt());
                    break;
                }
                case MAXPEACEFUL: {
                    builder.maxPeaceful(object.getAsJsonPrimitive("maxpeaceful").getAsInt());
                    break;
                }
                case MAXNEUTRAL: {
                    builder.maxNeutral(object.getAsJsonPrimitive("maxneutral").getAsInt());
                }
            }
        }
    }

    static {
        for (Cmd cmd : Cmd.values()) {
            CONDITIONS.put(cmd.name().toLowerCase(), cmd);
        }
    }

    public static class Builder {
        private final Set<RegistryKey<World>> dimensions = new HashSet<RegistryKey<World>>();
        private int mindist = 24;
        private int maxdist = 120;
        private int mindaycount = 0;
        private int maxdaycount = Integer.MAX_VALUE;
        private int minheight = 1;
        private int maxheight = 256;
        private boolean inLiquid = false;
        private boolean inWater = false;
        private boolean inLava = false;
        private boolean inAir = false;
        private boolean noRestrictions = false;
        private int maxthis = -1;
        private int maxlocal = -1;
        private int maxtotal = -1;
        private int maxhostile = -1;
        private int maxpeaceful = -1;
        private int maxneutral = -1;

        public Builder dimensions(RegistryKey<World> ... dimensions) {
            Collections.addAll(this.dimensions, dimensions);
            return this;
        }

        public Builder noRestrictions(boolean noRestrictions) {
            this.noRestrictions = noRestrictions;
            return this;
        }

        public Builder daycount(int min, int max) {
            this.mindaycount = min;
            this.maxdaycount = max;
            return this;
        }

        public Builder distance(int min, int max) {
            this.mindist = min;
            this.maxdist = max;
            return this;
        }

        public Builder height(int min, int max) {
            this.minheight = min;
            this.maxheight = max;
            return this;
        }

        public Builder inLiquid(boolean inLiquid) {
            this.inLiquid = inLiquid;
            return this;
        }

        public Builder inWater(boolean inWater) {
            this.inWater = inWater;
            return this;
        }

        public Builder inLava(boolean inLava) {
            this.inLava = inLava;
            return this;
        }

        public Builder inAir(boolean inAir) {
            this.inAir = inAir;
            return this;
        }

        public Builder maxThis(int maxThis) {
            this.maxthis = maxThis;
            return this;
        }

        public Builder maxLocal(int maxLocal) {
            this.maxlocal = maxLocal;
            return this;
        }

        public Builder maxTotal(int maxTotal) {
            this.maxtotal = maxTotal;
            return this;
        }

        public Builder maxHostile(int maxHostile) {
            this.maxhostile = maxHostile;
            return this;
        }

        public Builder maxPeaceful(int maxPeaceful) {
            this.maxpeaceful = maxPeaceful;
            return this;
        }

        public Builder maxNeutral(int maxNeutral) {
            this.maxneutral = maxNeutral;
            return this;
        }

        public SpawnerConditions build() {
            return new SpawnerConditions(this);
        }
    }

    static enum Cmd {
        DIMENSION,
        MINDIST,
        MAXDIST,
        MINDAYCOUNT,
        MAXDAYCOUNT,
        MINHEIGHT,
        MAXHEIGHT,
        INWATER,
        INLAVA,
        INLIQUID,
        INAIR,
        NORESTRICTIONS,
        MAXTHIS,
        MAXLOCAL,
        MAXTOTAL,
        MAXHOSTILE,
        MAXPEACEFUL,
        MAXNEUTRAL;

    }
}

