/*
 * Decompiled with CFR 0.152.
 */
package mcjty.incontrol.rules.support;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import mcjty.incontrol.ErrorHandler;
import mcjty.incontrol.InControl;
import mcjty.incontrol.compat.ModRuleCompatibilityLayer;
import mcjty.incontrol.data.DataStorage;
import mcjty.incontrol.rules.support.RuleKeys;
import mcjty.incontrol.spawner.SpawnerSystem;
import mcjty.incontrol.tools.rules.CommonRuleEvaluator;
import mcjty.incontrol.tools.rules.IEventQuery;
import mcjty.incontrol.tools.typed.AttributeMap;
import mcjty.incontrol.tools.varia.Tools;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;

public class GenericRuleEvaluator
extends CommonRuleEvaluator {
    public GenericRuleEvaluator(AttributeMap map) {
        super(map, InControl.setup.getLogger(), new ModRuleCompatibilityLayer());
    }

    @Override
    protected void addChecks(AttributeMap map) {
        super.addChecks(map);
        map.consume(RuleKeys.ONJOIN, b -> {});
        map.consume(RuleKeys.PHASE, b -> {});
        map.consume(RuleKeys.HOSTILE, this::addHostileCheck);
        map.consume(RuleKeys.PASSIVE, this::addPassiveCheck);
        map.consume(RuleKeys.BABY, this::addBabyCheck);
        map.consume(RuleKeys.CANSPAWNHERE, this::addCanSpawnHereCheck);
        map.consume(RuleKeys.NOTCOLLIDING, this::addNotCollidingCheck);
        map.consume(RuleKeys.SPAWNER, this::addSpawnerCheck);
        map.consume(RuleKeys.INCONTROL, this::addInControlCheck);
        map.consumeAsList(RuleKeys.MOB, this::addMobsCheck);
        map.consume(RuleKeys.PLAYER, this::addPlayerCheck);
        map.consume(RuleKeys.REALPLAYER, this::addRealPlayerCheck);
        map.consume(RuleKeys.FAKEPLAYER, this::addFakePlayerCheck);
        map.consume(RuleKeys.EXPLOSION, this::addExplosionCheck);
        map.consume(RuleKeys.PROJECTILE, this::addProjectileCheck);
        map.consume(RuleKeys.FIRE, this::addFireCheck);
        map.consume(RuleKeys.MAGIC, this::addMagicCheck);
        map.consumeAsList(RuleKeys.SOURCE, this::addSourceCheck);
        map.consumeAsList(RuleKeys.MOD, this::addModsCheck);
        map.consume(RuleKeys.MINCOUNT, this::addMinCountCheck);
        map.consume(RuleKeys.MAXCOUNT, this::addMaxCountCheck);
        map.consume(RuleKeys.DAYCOUNT, this::addDayCountCheck);
        map.consume(RuleKeys.MINDAYCOUNT, this::addMinDayCountCheck);
        map.consume(RuleKeys.MAXDAYCOUNT, this::addMaxDayCountCheck);
    }

    private void addCanSpawnHereCheck(boolean c) {
        if (c) {
            this.checks.add((event, query) -> {
                Entity entity = query.getEntity(event);
                if (entity instanceof MobEntity) {
                    return MobEntity.func_223315_a((EntityType)entity.func_200600_R(), (IWorld)entity.func_130014_f_(), (SpawnReason)SpawnReason.NATURAL, (BlockPos)entity.func_233580_cy_(), null);
                }
                return false;
            });
        } else {
            this.checks.add((event, query) -> {
                Entity entity = query.getEntity(event);
                if (entity instanceof MobEntity) {
                    return !MobEntity.func_223315_a((EntityType)entity.func_200600_R(), (IWorld)entity.func_130014_f_(), (SpawnReason)SpawnReason.NATURAL, (BlockPos)entity.func_233580_cy_(), null);
                }
                return true;
            });
        }
    }

    private void addNotCollidingCheck(boolean c) {
        if (c) {
            this.checks.add((event, query) -> {
                Entity entity = query.getEntity(event);
                if (entity instanceof MobEntity) {
                    return ((MobEntity)entity).func_205019_a((IWorldReader)entity.func_130014_f_());
                }
                return false;
            });
        } else {
            this.checks.add((event, query) -> {
                Entity entity = query.getEntity(event);
                if (entity instanceof MobEntity) {
                    return !((MobEntity)entity).func_205019_a((IWorldReader)entity.func_130014_f_());
                }
                return true;
            });
        }
    }

    private void addInControlCheck(boolean c) {
        this.checks.add((event, query) -> c == (SpawnerSystem.busySpawning != null));
    }

    private void addSpawnerCheck(boolean c) {
        if (c) {
            this.checks.add((event, query) -> {
                if (event instanceof LivingSpawnEvent.CheckSpawn) {
                    LivingSpawnEvent.CheckSpawn checkSpawn = (LivingSpawnEvent.CheckSpawn)event;
                    return checkSpawn.isSpawner();
                }
                return false;
            });
        } else {
            this.checks.add((event, query) -> {
                if (event instanceof LivingSpawnEvent.CheckSpawn) {
                    LivingSpawnEvent.CheckSpawn checkSpawn = (LivingSpawnEvent.CheckSpawn)event;
                    return !checkSpawn.isSpawner();
                }
                return false;
            });
        }
    }

    private void addBabyCheck(boolean baby) {
        this.checks.add((event, query) -> {
            Entity entity = query.getEntity(event);
            if (entity instanceof LivingEntity) {
                return ((LivingEntity)entity).func_70631_g_() == baby;
            }
            return false;
        });
    }

    private void addHostileCheck(boolean hostile) {
        if (hostile) {
            this.checks.add((event, query) -> query.getEntity(event) instanceof IMob);
        } else {
            this.checks.add((event, query) -> !(query.getEntity(event) instanceof IMob));
        }
    }

    private void addPassiveCheck(boolean passive) {
        if (passive) {
            this.checks.add((event, query) -> query.getEntity(event) instanceof AnimalEntity && !(query.getEntity(event) instanceof IMob));
        } else {
            this.checks.add((event, query) -> !(query.getEntity(event) instanceof AnimalEntity) || query.getEntity(event) instanceof IMob);
        }
    }

    private void addMobsCheck(List<String> mobs) {
        if (mobs.size() == 1) {
            EntityType type;
            String id = mobs.get(0);
            if (!ForgeRegistries.ENTITIES.containsKey(new ResourceLocation(id))) {
                ErrorHandler.error("Unknown mob '" + id + "'!");
            }
            if ((type = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(id))) != null) {
                this.checks.add((event, query) -> type.equals(query.getEntity(event).func_200600_R()));
            }
        } else {
            HashSet<EntityType> classes = new HashSet<EntityType>();
            for (String id : mobs) {
                EntityType type = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(id));
                if (type != null) {
                    classes.add(type);
                    continue;
                }
                ErrorHandler.error("Unknown mob '" + id + "'!");
            }
            if (!classes.isEmpty()) {
                this.checks.add((event, query) -> classes.contains(query.getEntity(event).func_200600_R()));
            }
        }
    }

    private void addModsCheck(List<String> mods) {
        if (mods.size() == 1) {
            String modid = mods.get(0);
            this.checks.add((event, query) -> {
                String mod = query.getEntity(event).func_200600_R().getRegistryName().func_110624_b();
                return modid.equals(mod);
            });
        } else {
            HashSet<String> modids = new HashSet<String>();
            for (String modid : mods) {
                modids.add(modid);
            }
            this.checks.add((event, query) -> {
                String mod = query.getEntity(event).func_200600_R().getRegistryName().func_110624_b();
                return modids.contains(mod);
            });
        }
    }

    @Nullable
    private CountInfo parseCountInfo(String json) {
        JsonParser parser = new JsonParser();
        JsonElement element = parser.parse(json);
        if (element.isJsonPrimitive()) {
            if (element.getAsJsonPrimitive().isString()) {
                int amount;
                String[] splitted = StringUtils.split((String)element.getAsString(), (char)',');
                try {
                    amount = Integer.parseInt(splitted[0]);
                }
                catch (NumberFormatException e) {
                    ErrorHandler.error("Bad amount for mincount '" + splitted[0] + "'!");
                    return null;
                }
                EntityType entityClass = null;
                if (splitted.length > 1 && (entityClass = this.findEntity(splitted[1])) == null) {
                    ErrorHandler.error("Cannot find mob '" + splitted[1] + "'!");
                    return null;
                }
                return new CountInfo().setAmount(amount).addEntityType(entityClass);
            }
            int amount = element.getAsInt();
            return new CountInfo().setAmount(amount);
        }
        if (element.isJsonObject()) {
            String error;
            JsonObject obj = element.getAsJsonObject();
            int amount = obj.get("amount").getAsInt();
            CountInfo info = new CountInfo().setAmount(amount);
            if (obj.has("mob")) {
                if (obj.get("mob").isJsonPrimitive()) {
                    String entity = obj.get("mob").getAsString();
                    EntityType entityType = this.findEntity(entity);
                    if (entityType == null) {
                        return null;
                    }
                    info.addEntityType(entityType);
                } else if (obj.get("mob").isJsonArray()) {
                    JsonArray array = obj.get("mob").getAsJsonArray();
                    for (JsonElement el : array) {
                        String entity = el.getAsString();
                        EntityType entityType = this.findEntity(entity);
                        if (entityType == null) {
                            ErrorHandler.error("Cannot find mob '" + entity + "'!");
                            return null;
                        }
                        info.addEntityType(entityType);
                    }
                } else {
                    ErrorHandler.error("Bad entity tag in count description!");
                    return null;
                }
            }
            if (obj.has("mod")) {
                String mod = obj.get("mod").getAsString();
                info.setMod(mod);
            }
            if (obj.has("perplayer")) {
                info.setScaledPerPlayer(obj.get("perplayer").getAsBoolean());
            }
            if (obj.has("perchunk")) {
                info.setScaledPerChunk(obj.get("perchunk").getAsBoolean());
            }
            if (obj.has("passive")) {
                info.setPassive(obj.get("passive").getAsBoolean());
            }
            if (obj.has("all")) {
                info.setAll(obj.get("all").getAsBoolean());
            }
            if (obj.has("hostile")) {
                info.setHostile(obj.get("hostile").getAsBoolean());
            }
            if ((error = info.validate()) != null) {
                ErrorHandler.error(error);
                return null;
            }
            return info;
        }
        ErrorHandler.error("Count description '" + json + "' is not valid!");
        return null;
    }

    private EntityType findEntity(String id) {
        EntityType ee = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(id));
        if (ee == null) {
            ErrorHandler.error("Unknown mob '" + id + "'!");
            return null;
        }
        return ee;
    }

    private void addMinCountCheck(String json) {
        CountInfo info = this.parseCountInfo(json);
        if (info == null) {
            return;
        }
        BiFunction<IWorld, Entity, Integer> counter = this.getCounter(info);
        Function<IWorld, Integer> amountAdjuster = this.getAmountAdjuster(info, info.amount);
        this.checks.add((event, query) -> {
            int amount;
            Entity entity;
            IWorld world = query.getWorld(event);
            int count = (Integer)counter.apply(world, entity = query.getEntity(event));
            return count >= (amount = ((Integer)amountAdjuster.apply(world)).intValue());
        });
    }

    private void addMaxCountCheck(String json) {
        CountInfo info = this.parseCountInfo(json);
        BiFunction<IWorld, Entity, Integer> counter = this.getCounter(info);
        Function<IWorld, Integer> amountAdjuster = this.getAmountAdjuster(info, info.amount);
        this.checks.add((event, query) -> {
            int amount;
            Entity entity;
            IWorld world = query.getWorld(event);
            int count = (Integer)counter.apply(world, entity = query.getEntity(event));
            return count < (amount = ((Integer)amountAdjuster.apply(world)).intValue());
        });
    }

    private void addDayCountCheck(Integer count) {
        if (count == null) {
            return;
        }
        this.checks.add((event, query) -> {
            IWorld world = query.getWorld(event);
            DataStorage data = DataStorage.getData((World)Tools.getServerWorld(world));
            int amount = data.getDaycounter();
            return amount % count == 0;
        });
    }

    private void addMinDayCountCheck(Integer count) {
        if (count == null) {
            return;
        }
        this.checks.add((event, query) -> {
            IWorld world = query.getWorld(event);
            DataStorage data = DataStorage.getData((World)Tools.getServerWorld(world));
            int amount = data.getDaycounter();
            return amount >= count;
        });
    }

    private void addMaxDayCountCheck(Integer count) {
        if (count == null) {
            return;
        }
        this.checks.add((event, query) -> {
            IWorld world = query.getWorld(event);
            DataStorage data = DataStorage.getData((World)Tools.getServerWorld(world));
            int amount = data.getDaycounter();
            return amount < count;
        });
    }

    private Function<IWorld, Integer> getAmountAdjuster(CountInfo info, int infoAmount) {
        Function<IWorld, Integer> amountAdjuster = info.scaledPerChunk ? world -> infoAmount * InControl.setup.cache.getValidSpawnChunks((IWorld)world) / 289 : (info.scaledPerPlayer ? world -> infoAmount * InControl.setup.cache.getValidPlayers((IWorld)world) : world -> infoAmount);
        return amountAdjuster;
    }

    private BiFunction<IWorld, Entity, Integer> getCounter(CountInfo info) {
        List infoEntityType;
        BiFunction<IWorld, Entity, Integer> counter = info.mod != null ? (info.hostile ? (world, entity) -> InControl.setup.cache.getCountPerModHostile((IWorld)world, info.mod) : (info.passive ? (world, entity) -> InControl.setup.cache.getCountPerModPassive((IWorld)world, info.mod) : (info.all ? (world, entity) -> InControl.setup.cache.getCountPerModAll((IWorld)world, info.mod) : (world, entity) -> InControl.setup.cache.getCountPerMod((IWorld)world, info.mod)))) : (info.hostile ? (world, entity) -> InControl.setup.cache.getCountHostile((IWorld)world) : (info.passive ? (world, entity) -> InControl.setup.cache.getCountPassive((IWorld)world) : (info.all ? (world, entity) -> InControl.setup.cache.getCountAll((IWorld)world) : ((infoEntityType = info.entityTypes).isEmpty() ? (world, entity) -> InControl.setup.cache.getCount((IWorld)world, entity.func_200600_R()) : (infoEntityType.size() == 1 ? (world, entity) -> {
            EntityType entityType = (EntityType)infoEntityType.get(0);
            return InControl.setup.cache.getCount((IWorld)world, entityType);
        } : (world, entity) -> {
            int amount = 0;
            for (EntityType cls : infoEntityType) {
                amount += InControl.setup.cache.getCount((IWorld)world, cls);
            }
            return amount;
        })))));
        return counter;
    }

    private void addPlayerCheck(boolean asPlayer) {
        if (asPlayer) {
            this.checks.add((event, query) -> query.getAttacker(event) instanceof PlayerEntity);
        } else {
            this.checks.add((event, query) -> query.getAttacker(event) instanceof PlayerEntity);
        }
    }

    private boolean isFakePlayer(Entity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        if (entity instanceof FakePlayer) {
            return true;
        }
        PlayerList playerList = entity.func_130014_f_().func_73046_m().func_184103_al();
        ServerPlayerEntity playerByUUID = playerList.func_177451_a(((PlayerEntity)entity).func_146103_bH().getId());
        if (playerByUUID == null) {
            return true;
        }
        return entity != playerByUUID;
    }

    private boolean isRealPlayer(Entity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        return !this.isFakePlayer(entity);
    }

    private void addRealPlayerCheck(boolean asPlayer) {
        if (asPlayer) {
            this.checks.add((event, query) -> query.getAttacker(event) == null ? false : this.isRealPlayer(query.getAttacker(event)));
        } else {
            this.checks.add((event, query) -> query.getAttacker(event) == null ? true : !this.isRealPlayer(query.getAttacker(event)));
        }
    }

    private void addFakePlayerCheck(boolean asPlayer) {
        if (asPlayer) {
            this.checks.add((event, query) -> query.getAttacker(event) == null ? false : this.isFakePlayer(query.getAttacker(event)));
        } else {
            this.checks.add((event, query) -> query.getAttacker(event) == null ? true : !this.isFakePlayer(query.getAttacker(event)));
        }
    }

    private void addExplosionCheck(boolean explosion) {
        if (explosion) {
            this.checks.add((event, query) -> query.getSource(event) == null ? false : query.getSource(event).func_94541_c());
        } else {
            this.checks.add((event, query) -> query.getSource(event) == null ? true : !query.getSource(event).func_94541_c());
        }
    }

    private void addProjectileCheck(boolean projectile) {
        if (projectile) {
            this.checks.add((event, query) -> query.getSource(event) == null ? false : query.getSource(event).func_76352_a());
        } else {
            this.checks.add((event, query) -> query.getSource(event) == null ? true : !query.getSource(event).func_76352_a());
        }
    }

    private void addFireCheck(boolean fire) {
        if (fire) {
            this.checks.add((event, query) -> query.getSource(event) == null ? false : query.getSource(event).func_76347_k());
        } else {
            this.checks.add((event, query) -> query.getSource(event) == null ? true : !query.getSource(event).func_76347_k());
        }
    }

    private void addMagicCheck(boolean magic) {
        if (magic) {
            this.checks.add((event, query) -> query.getSource(event) == null ? false : query.getSource(event).func_82725_o());
        } else {
            this.checks.add((event, query) -> query.getSource(event) == null ? true : !query.getSource(event).func_82725_o());
        }
    }

    private void addSourceCheck(List<String> sources) {
        HashSet<String> sourceSet = new HashSet<String>(sources);
        this.checks.add((event, query) -> {
            if (query.getSource(event) == null) {
                return false;
            }
            return sourceSet.contains(query.getSource(event).func_76355_l());
        });
    }

    @Override
    public boolean match(Object event, IEventQuery query) {
        for (BiFunction rule : this.checks) {
            if (((Boolean)rule.apply(event, query)).booleanValue()) continue;
            return false;
        }
        return true;
    }

    private static class CountInfo {
        private int amount;
        private List<EntityType> entityTypes = new ArrayList<EntityType>();
        private boolean scaledPerPlayer = false;
        private boolean scaledPerChunk = false;
        private boolean passive = false;
        private boolean hostile = false;
        private boolean all = false;
        private String mod = null;

        public CountInfo setAmount(int amount) {
            this.amount = amount;
            return this;
        }

        public CountInfo addEntityType(EntityType entityClass) {
            if (entityClass != null) {
                this.entityTypes.add(entityClass);
            }
            return this;
        }

        public CountInfo setScaledPerPlayer(boolean scaledPerPlayer) {
            this.scaledPerPlayer = scaledPerPlayer;
            return this;
        }

        public CountInfo setScaledPerChunk(boolean scaledPerChunk) {
            this.scaledPerChunk = scaledPerChunk;
            return this;
        }

        public CountInfo setAll(boolean all) {
            this.all = all;
            return this;
        }

        public CountInfo setPassive(boolean passive) {
            this.passive = passive;
            return this;
        }

        public CountInfo setHostile(boolean hostile) {
            this.hostile = hostile;
            return this;
        }

        public CountInfo setMod(String mod) {
            this.mod = mod;
            return this;
        }

        public String validate() {
            if (this.scaledPerPlayer && this.scaledPerChunk) {
                return "You cannot combine 'perchunk' and 'perplayer'!";
            }
            if (this.mod != null && !this.entityTypes.isEmpty()) {
                return "You cannot combine 'mod' with 'mob'!";
            }
            if (this.passive && this.hostile || this.all && this.passive || this.all && this.hostile) {
                return "Don't use all, passive, and hostile at the same time!";
            }
            if ((this.passive || this.hostile || this.all) && !this.entityTypes.isEmpty()) {
                return "You cannot combine 'all', 'passive', or 'hostile' with 'mob'!";
            }
            return null;
        }
    }
}

