/*
 * Decompiled with CFR 0.152.
 */
package mcjty.incontrol.data;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import mcjty.incontrol.rules.PhaseRule;
import mcjty.incontrol.rules.RulesManager;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.WorldSavedData;

public class DataStorage
extends WorldSavedData {
    private static final String NAME = "InControlData";
    private Boolean isDay = null;
    private int daycounter = 0;
    private final Set<String> phases = new HashSet<String>();
    private int checkCounter = 0;

    public DataStorage() {
        super(NAME);
    }

    @Nonnull
    public static DataStorage getData(World world) {
        if (world.func_201670_d()) {
            throw new RuntimeException("Don't access this client-side!");
        }
        MinecraftServer server = world.func_73046_m();
        ServerWorld overworld = server.func_71218_a(World.field_234918_g_);
        DimensionSavedDataManager storage = overworld.func_217481_x();
        return (DataStorage)storage.func_215752_a(DataStorage::new, NAME);
    }

    public int getDaycounter() {
        return this.daycounter;
    }

    public void setDaycounter(int daycounter) {
        this.daycounter = daycounter;
        this.func_76185_a();
    }

    public Boolean getDay() {
        return this.isDay;
    }

    public void setDay(Boolean day) {
        this.isDay = day;
    }

    public Set<String> getPhases() {
        return this.phases;
    }

    public void tick(World world) {
        this.tickTime(world);
        --this.checkCounter;
        if (this.checkCounter <= 0) {
            this.checkCounter = 10;
            this.tickPhases(world);
        }
    }

    private void tickTime(World world) {
        boolean day;
        long time = world.func_72820_D() % 24000L;
        boolean bl = day = time >= 0L && time < 12000L;
        if (this.isDay == null) {
            this.isDay = day;
            this.func_76185_a();
        } else if (day != this.isDay) {
            if (day) {
                ++this.daycounter;
            }
            this.isDay = day;
            this.func_76185_a();
        }
    }

    private void tickPhases(World world) {
        boolean dirty = false;
        for (PhaseRule rule : RulesManager.phaseRules) {
            if (rule.match((IWorld)world)) {
                if (!this.phases.add(rule.getName())) continue;
                dirty = true;
                continue;
            }
            if (!this.phases.remove(rule.getName())) continue;
            dirty = true;
        }
        if (dirty) {
            RulesManager.onPhaseChange();
        }
    }

    public void func_76184_a(CompoundNBT tag) {
        this.daycounter = tag.func_74762_e("daycounter");
        this.isDay = tag.func_74764_b("isday") ? Boolean.valueOf(tag.func_74767_n("isday")) : null;
    }

    public CompoundNBT func_189551_b(CompoundNBT tag) {
        tag.func_74768_a("daycounter", this.daycounter);
        if (this.isDay != null) {
            tag.func_74757_a("isday", this.isDay.booleanValue());
        }
        return tag;
    }
}

