/*
 * Decompiled with CFR 0.152.
 */
package mcjty.incontrol.tools.varia;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public class JSonTools {
    public static JsonElement getRootElement(String path, String filename, Logger logger) {
        BufferedReader br;
        File file = path == null ? new File(filename) : new File(path + File.separator + "incontrol", filename);
        if (!file.exists()) {
            JSonTools.makeEmptyRuleFile(file, logger);
            return null;
        }
        logger.log(Level.INFO, "Reading rules from " + filename);
        FileInputStream inputstream = null;
        try {
            inputstream = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            logger.log(Level.ERROR, "Error reading " + filename + "!");
            return null;
        }
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)inputstream, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            logger.log(Level.ERROR, "Error reading " + filename + "!");
            return null;
        }
        JsonParser parser = new JsonParser();
        JsonElement element = parser.parse((Reader)br);
        return element;
    }

    private static void makeEmptyRuleFile(File file, Logger logger) {
        PrintWriter writer;
        try {
            writer = new PrintWriter(file);
        }
        catch (FileNotFoundException e) {
            logger.log(Level.ERROR, "Error writing " + file.getName() + "!");
            return;
        }
        JsonArray array = new JsonArray();
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        writer.print(gson.toJson((JsonElement)array));
        writer.close();
    }

    public static Optional<JsonElement> getElement(JsonObject element, String name) {
        JsonElement el = element.get(name);
        if (el != null) {
            return Optional.of(el);
        }
        return Optional.empty();
    }

    @Nullable
    public static Float parseFloat(JsonObject jsonObject, String name) {
        if (jsonObject.has(name)) {
            return Float.valueOf(jsonObject.get(name).getAsFloat());
        }
        return null;
    }

    @Nullable
    public static Integer parseInt(JsonObject jsonObject, String name) {
        if (jsonObject.has(name)) {
            return jsonObject.get(name).getAsInt();
        }
        return null;
    }

    @Nullable
    public static Boolean parseBool(JsonObject jsonObject, String name) {
        if (jsonObject.has(name)) {
            return jsonObject.get(name).getAsBoolean();
        }
        return null;
    }

    public static Stream<Pair<String, String>> asPairs(JsonElement element) {
        Stream.Builder<Pair> builder = Stream.builder();
        for (Map.Entry entry : element.getAsJsonObject().entrySet()) {
            builder.add(Pair.of(entry.getKey(), (Object)((JsonElement)entry.getValue()).getAsString()));
        }
        return builder.build();
    }

    public static Stream<JsonElement> asArrayOrSingle(JsonElement element) {
        if (element.isJsonArray()) {
            Stream.Builder<JsonElement> builder = Stream.builder();
            for (JsonElement el : element.getAsJsonArray()) {
                builder.add(el);
            }
            return builder.build();
        }
        return Stream.of(element);
    }

    public static void addPairs(JsonObject parent, String name, Map<String, String> pairs) {
        if (pairs != null) {
            JsonObject object = new JsonObject();
            for (Map.Entry<String, String> entry : pairs.entrySet()) {
                object.add(entry.getKey(), (JsonElement)new JsonPrimitive(entry.getValue()));
            }
            parent.add(name, (JsonElement)object);
        }
    }

    public static void addArrayOrSingle(JsonObject parent, String name, Collection<String> strings) {
        if (strings != null) {
            if (strings.size() == 1) {
                parent.add(name, (JsonElement)new JsonPrimitive(strings.iterator().next()));
            } else {
                JsonArray array = new JsonArray();
                for (String value : strings) {
                    array.add((JsonElement)new JsonPrimitive(value));
                }
                parent.add(name, (JsonElement)array);
            }
        }
    }

    public static void addIntArrayOrSingle(JsonObject parent, String name, Collection<Integer> integers) {
        if (integers != null) {
            if (integers.size() == 1) {
                parent.add(name, (JsonElement)new JsonPrimitive((Number)integers.iterator().next()));
            } else {
                JsonArray array = new JsonArray();
                for (Integer value : integers) {
                    array.add((JsonElement)new JsonPrimitive((Number)value));
                }
                parent.add(name, (JsonElement)array);
            }
        }
    }
}

