/*
 * Decompiled with CFR 0.152.
 */
package twistedgate.immersiveposts.client.model;

import blusunrize.immersiveengineering.api.utils.QuadTransformer;
import blusunrize.immersiveengineering.api.utils.client.CombinedModelData;
import blusunrize.immersiveengineering.api.utils.client.SinglePropertyModelData;
import blusunrize.immersiveengineering.client.utils.ModelUtils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import twistedgate.immersiveposts.client.model.IPOBakedModel;
import twistedgate.immersiveposts.client.model.IPOModelData;
import twistedgate.immersiveposts.common.tileentity.PostBaseTileEntity;

public class PostBaseModel
extends IPOBakedModel {
    public static final Cache<Key, SpecialPostBaseModel> CACHE = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.MINUTES).maximumSize(100L).build();
    static TextureAtlasSprite postbaseSprite;

    @Override
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        Key key;
        SpecialPostBaseModel special;
        BlockState hState = Blocks.field_150346_d.func_176223_P();
        Int2IntFunction colorMul = i -> -1;
        Direction facing = Direction.NORTH;
        if (extraData.hasProperty(IPOModelData.POSTBASE)) {
            IPOModelData.PostBaseModelData data = (IPOModelData.PostBaseModelData)extraData.getData(IPOModelData.POSTBASE);
            hState = data.state;
            colorMul = data.color;
            facing = data.facing;
        }
        if ((special = (SpecialPostBaseModel)CACHE.getIfPresent((Object)(key = new Key(hState, colorMul, facing)))) == null) {
            special = new SpecialPostBaseModel(key, colorMul);
            CACHE.put((Object)key, (Object)special);
        }
        return special.func_200117_a(state, side, rand);
    }

    public IModelData getModelData(IBlockDisplayReader world, BlockPos pos, BlockState state, IModelData tileData) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(tileData);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof PostBaseTileEntity) {
            PostBaseTileEntity base = (PostBaseTileEntity)te;
            IPOModelData.PostBaseModelData data = new IPOModelData.PostBaseModelData(base.getCoverState(), base.getFacing(), i -> i);
            list.add(new SinglePropertyModelData((Object)data, IPOModelData.POSTBASE));
        }
        return CombinedModelData.combine((IModelData[])list.toArray(new IModelData[0]));
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_188618_c() {
        return false;
    }

    static TextureAtlasSprite getPostbaseSprite() {
        if (postbaseSprite == null) {
            postbaseSprite = Minecraft.func_71410_x().func_209506_al().func_229356_a_(PlayerContainer.field_226615_c_).func_195424_a(new ResourceLocation("immersiveposts", "block/postbase"));
        }
        return postbaseSprite;
    }

    public TextureAtlasSprite func_177554_e() {
        return PostBaseModel.getPostbaseSprite();
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }

    private static class Key {
        final BlockState state;
        final Direction facing;
        @Nullable
        Int2IntMap usedColorMultipliers;
        @Nullable
        final Int2IntFunction allColorMultipliers;

        public Key(BlockState state, Int2IntFunction colorMul, Direction facing) {
            this.state = state;
            this.facing = facing;
            this.allColorMultipliers = colorMul;
            this.usedColorMultipliers = null;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj != null && obj instanceof Key) {
                Key other = (Key)obj;
                return this.state.equals(other.state) && this.facing == other.facing && this.sameColorMultipliersAs(other);
            }
            return false;
        }

        private boolean sameColorMultipliersAs(Key that) {
            if (that.usedColorMultipliers != null && this.usedColorMultipliers != null) {
                return this.usedColorMultipliers.equals(that.usedColorMultipliers);
            }
            if (that.usedColorMultipliers != null && this.allColorMultipliers != null) {
                IntIterator intIterator = that.usedColorMultipliers.keySet().iterator();
                while (intIterator.hasNext()) {
                    int i = (Integer)intIterator.next();
                    if (this.allColorMultipliers.get(i) == that.usedColorMultipliers.get(i)) continue;
                    return false;
                }
                return true;
            }
            if (that.allColorMultipliers != null && this.usedColorMultipliers != null) {
                return that.sameColorMultipliersAs(this);
            }
            throw new IllegalStateException("Can't compare PostBaseModel. Key's that use functions!");
        }

        public int hashCode() {
            return 31 * this.state.hashCode() + Objects.hash(this.facing);
        }
    }

    private static class SpecialPostBaseModel
    extends PostBaseModel {
        private static final Random RANDOM = new Random();
        private static final Vector3d[] verts = new Vector3d[]{new Vector3d(0.25, (double)1.001f, 0.25), new Vector3d(0.25, (double)1.001f, 0.75), new Vector3d(0.75, (double)1.001f, 0.75), new Vector3d(0.75, (double)1.001f, 0.25)};
        private static final double[] uvs = new double[]{8.0, 0.0, 16.0, 8.0};
        private static final float[] color = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        List<List<BakedQuad>> quads = new ArrayList<List<BakedQuad>>(6);

        public SpecialPostBaseModel(Key key, Int2IntFunction colorMul) {
            this.build(key, colorMul);
        }

        private void build(Key key, Int2IntFunction colorMulBasic) {
            if (colorMulBasic == null) {
                ItemColors colors = Minecraft.func_71410_x().getItemColors();
                ItemStack stack = new ItemStack((IItemProvider)key.state.func_177230_c());
                colorMulBasic = i -> colors.func_186728_a(stack, i);
            }
            key.usedColorMultipliers = new Int2IntOpenHashMap();
            Int2IntFunction f = colorMulBasic;
            Int2IntFunction colorMul = i -> {
                int v = f.get(i);
                key.usedColorMultipliers.put(i, v);
                return v;
            };
            QuadTransformer tintTransformer = new QuadTransformer(TransformationMatrix.func_227983_a_(), colorMul);
            IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(key.state);
            for (Direction side : Direction.values()) {
                List quads = model.getQuads(key.state, side, RANDOM, (IModelData)EmptyModelData.INSTANCE).stream().map(tintTransformer).collect(Collectors.toCollection(ArrayList::new));
                if (side == Direction.UP) {
                    TextureAtlasSprite sprite = SpecialPostBaseModel.getPostbaseSprite();
                    quads.add(ModelUtils.createBakedQuad((VertexFormat)DefaultVertexFormats.field_176600_a, (Vector3d[])verts, (Direction)side, (TextureAtlasSprite)sprite, (double[])uvs, (float[])color, (boolean)false));
                }
                this.quads.add(quads);
            }
            this.quads.add((List<BakedQuad>)ImmutableList.of());
        }

        @Override
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
            return this.quads.get(side == null ? this.quads.size() - 1 : side.func_176745_a());
        }
    }
}

