/*
 * Decompiled with CFR 0.152.
 */
package twistedgate.immersiveposts.client;

import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.resources.IResourceManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.ISelectiveResourceReloadListener;
import net.minecraftforge.resource.VanillaResourceType;
import twistedgate.immersiveposts.client.model.PostBaseModel;
import twistedgate.immersiveposts.common.IPOContent;
import twistedgate.immersiveposts.enums.EnumPostMaterial;

@Mod.EventBusSubscriber(modid="immersiveposts", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientEventHandler
implements ISelectiveResourceReloadListener {
    public void onResourceManagerReload(IResourceManager resourceManager, Predicate<IResourceType> resourcePredicate) {
        if (resourcePredicate.test((IResourceType)VanillaResourceType.TEXTURES)) {
            PostBaseModel.CACHE.invalidateAll();
        }
    }

    @SubscribeEvent
    public static void clientSetup(FMLClientSetupEvent event) {
        RenderTypeLookup.setRenderLayer((Block)((Block)IPOContent.Blocks.POST_BASE.get()), (RenderType)RenderType.func_228643_e_());
        Predicate<RenderType> type = t -> t == RenderType.func_228639_c_() || t == RenderType.func_228643_e_();
        for (EnumPostMaterial mat : EnumPostMaterial.values()) {
            RenderTypeLookup.setRenderLayer((Block)IPOContent.Blocks.Posts.get(mat), type);
            RenderTypeLookup.setRenderLayer((Block)IPOContent.Blocks.HorizontalTruss.get(mat), type);
        }
    }
}

