/*
 * Decompiled with CFR 0.152.
 */
package twistedgate.immersiveposts.common.tileentity;

import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.Lazy;
import twistedgate.immersiveposts.common.IPOContent;
import twistedgate.immersiveposts.common.blocks.PostBaseBlock;
import twistedgate.immersiveposts.common.tileentity.IPOTileEntityBase;

public class PostBaseTileEntity
extends IPOTileEntityBase {
    protected static final Lazy<BlockState> EMPTY = Lazy.of(() -> Blocks.field_150350_a.func_176223_P());
    @Nonnull
    protected ItemStack stack = ItemStack.field_190927_a;
    @Nonnull
    protected Lazy<BlockState> coverstate = EMPTY;
    protected Direction facing = Direction.NORTH;

    public PostBaseTileEntity() {
        super(IPOContent.TE_POSTBASE);
    }

    @Nonnull
    public ItemStack getStack() {
        return this.stack;
    }

    @Nonnull
    public BlockState getCoverState() {
        if (this.stack.func_190926_b()) {
            return (BlockState)EMPTY.get();
        }
        return (BlockState)this.coverstate.get();
    }

    public Direction getFacing() {
        return this.facing;
    }

    public void setFacing(Direction facing) {
        if (Direction.Plane.HORIZONTAL.test(facing)) {
            this.facing = facing;
            this.func_70296_d();
        }
    }

    public boolean setStack(ItemStack stack) {
        ItemStack last = this.stack;
        if (stack == null || stack.func_190926_b()) {
            this.stack = ItemStack.field_190927_a;
        } else if (stack.func_77973_b() instanceof BlockItem) {
            this.stack = stack;
        }
        boolean changed = !ItemStack.func_77989_b((ItemStack)this.stack, (ItemStack)last);
        this.updateLazy(changed);
        if (changed) {
            this.func_70296_d();
        }
        return changed;
    }

    @Override
    protected CompoundNBT writeCustom(CompoundNBT compound) {
        compound.func_74778_a("facing", this.facing != null ? this.facing.func_176742_j() : Direction.NORTH.func_176742_j());
        compound.func_218657_a("stack", (INBT)this.stack.serializeNBT());
        return compound;
    }

    @Override
    protected void readCustom(BlockState state, CompoundNBT compound) {
        this.facing = Direction.func_176739_a((String)compound.func_74779_i("facing"));
        ItemStack last = this.stack;
        this.stack = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("stack"));
        boolean changed = !ItemStack.func_77989_b((ItemStack)this.stack, (ItemStack)last);
        this.updateLazy(changed);
        if (changed && this.func_145831_w() != null) {
            this.func_145831_w().func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
        }
    }

    public boolean interact(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand) {
        ItemStack held = player.func_184586_b(Hand.MAIN_HAND);
        if (held == ItemStack.field_190927_a) {
            if (player.func_225608_bj_() && !this.getStack().func_190926_b()) {
                if (!world.field_72995_K) {
                    this.setFacing(Direction.NORTH);
                    Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)this.getStack());
                    this.setStack(ItemStack.field_190927_a);
                    world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)PostBaseBlock.HIDDEN, (Comparable)Boolean.valueOf(false)));
                }
                return true;
            }
        } else if (held.func_77973_b() instanceof BlockItem && this.isUsableCover(Block.func_149634_a((Item)held.func_77973_b()), (IBlockReader)world, pos) && this.getStack().func_190926_b()) {
            if (!world.field_72995_K) {
                this.setFacing(player.func_174811_aO().func_176734_d());
                ItemStack copy = held.func_77946_l();
                copy.func_190920_e(1);
                this.setStack(copy);
                if (!player.func_184812_l_()) {
                    held.func_190918_g(1);
                    if (held.func_190926_b()) {
                        player.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
                    }
                }
                world.func_175656_a(pos, (BlockState)((BlockState)state.func_206870_a((Property)PostBaseBlock.HIDDEN, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)PostBaseBlock.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
            }
            return true;
        }
        return false;
    }

    private boolean isUsableCover(@Nonnull Block block, @Nonnull IBlockReader reader, @Nonnull BlockPos pos) {
        BlockState state = block.func_176223_P();
        return block != Blocks.field_150350_a && state.func_215686_e(reader, pos) && state.func_200015_d(reader, pos);
    }

    protected void updateLazy(boolean changed) {
        if (!changed) {
            return;
        }
        this.coverstate = this.stack == null || this.stack.func_190926_b() ? EMPTY : Lazy.of(() -> {
            if (this.stack.func_77973_b() instanceof BlockItem) {
                BlockState state = ((BlockItem)this.stack.func_77973_b()).func_179223_d().func_176223_P();
                Optional<DirectionProperty> prop = state.func_235904_r_().stream().filter(p -> p instanceof DirectionProperty && p.func_177701_a().equals("facing")).map(p -> (DirectionProperty)p).filter(p -> p.func_177700_c().stream().allMatch(d -> Direction.Plane.HORIZONTAL.test(d))).findAny();
                if (prop.isPresent()) {
                    state = (BlockState)state.func_206870_a((Property)prop.get(), (Comparable)this.facing);
                }
                return state;
            }
            return (BlockState)EMPTY.get();
        });
    }
}

