/*
 * Decompiled with CFR 0.152.
 */
package twistedgate.immersiveposts.api.posts;

import javax.annotation.Nonnull;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import twistedgate.immersiveposts.api.posts.PostMaterialRegistry;
import twistedgate.immersiveposts.common.IPOConfig;
import twistedgate.immersiveposts.common.IPOContent;
import twistedgate.immersiveposts.common.blocks.HorizontalTrussBlock;
import twistedgate.immersiveposts.common.blocks.PostBlock;
import twistedgate.immersiveposts.enums.EnumPostMaterial;
import twistedgate.immersiveposts.enums.EnumPostType;

public interface IPostMaterial {
    public ItemStack getItemStack();

    public ResourceLocation getTexture();

    public Block getSourceBlock();

    public boolean isFence();

    public String getName();

    public String getBlockName();

    public AbstractBlock.Properties getBlockProperties();

    public static BlockState getPostState(@Nonnull ItemStack stack) {
        return IPostMaterial.getPostState(IPostMaterial.getPostMaterial(stack));
    }

    public static BlockState getPostState(IPostMaterial material) {
        PostBlock block = IPOContent.Blocks.Posts.get(material);
        if (block == null && PostMaterialRegistry.MAP.containsKey(material)) {
            block = (Block)PostMaterialRegistry.getPostFrom(material).get();
        }
        return (BlockState)block.func_176223_P().func_206870_a(PostBlock.TYPE, (Comparable)((Object)EnumPostType.POST_TOP));
    }

    public static BlockState getTrussState(@Nonnull ItemStack stack) {
        return IPostMaterial.getTrussState(IPostMaterial.getPostMaterial(stack));
    }

    public static BlockState getTrussState(@Nonnull IPostMaterial material) {
        HorizontalTrussBlock block = IPOContent.Blocks.HorizontalTruss.get(material);
        if (block == null && PostMaterialRegistry.MAP.containsKey(material)) {
            block = (Block)PostMaterialRegistry.getTrussFrom(material).get();
        }
        return block.func_176223_P();
    }

    public static IPostMaterial getPostMaterial(@Nonnull ItemStack stack) {
        for (EnumPostMaterial mat : EnumPostMaterial.values()) {
            if (!stack.func_77969_a(mat.getItemStack()) || !IPOConfig.MAIN.isEnabled(mat)) continue;
            return mat;
        }
        for (IPostMaterial mat : PostMaterialRegistry.MAP.keySet()) {
            if (!stack.func_77969_a(mat.getItemStack())) continue;
            return mat;
        }
        return null;
    }

    public static boolean isValidItem(ItemStack stack) {
        if (stack == null || stack.func_190926_b()) {
            return false;
        }
        for (EnumPostMaterial mat : EnumPostMaterial.values()) {
            if (!stack.func_77969_a(mat.getItemStack()) || !IPOConfig.MAIN.isEnabled(mat)) continue;
            return true;
        }
        for (IPostMaterial mat : PostMaterialRegistry.MAP.keySet()) {
            if (!stack.func_77969_a(mat.getItemStack())) continue;
            return true;
        }
        return false;
    }
}

