/*
 * Decompiled with CFR 0.152.
 */
package twistedgate.immersiveposts.api.posts;

import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.FenceBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import twistedgate.immersiveposts.api.posts.IPostMaterial;

public class BasicPostMaterial
implements IPostMaterial {
    private boolean isFence;
    private String name;
    private Block sourceBlock;
    private Supplier<Block> sourceBlockSupplier;
    private AbstractBlock.Properties properties;
    private ResourceLocation texture;

    public BasicPostMaterial(String materialName, AbstractBlock.Properties postBlockProperties, ResourceLocation postBlockTexture, Supplier<Block> sourceBlockSupplier) {
        this.name = materialName;
        this.properties = postBlockProperties;
        this.texture = postBlockTexture;
        this.sourceBlockSupplier = sourceBlockSupplier;
    }

    @Override
    public ItemStack getItemStack() {
        Block block = this.getSourceBlock();
        return block == null ? ItemStack.field_190927_a : new ItemStack((IItemProvider)block);
    }

    @Override
    public ResourceLocation getTexture() {
        return this.texture;
    }

    @Override
    public Block getSourceBlock() {
        if (this.sourceBlock == null) {
            this.sourceBlock = this.sourceBlockSupplier.get();
            this.isFence = this.sourceBlock != null && this.sourceBlock instanceof FenceBlock;
        }
        return this.sourceBlock;
    }

    @Override
    public boolean isFence() {
        return this.isFence;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getBlockName() {
        return this.name + "post";
    }

    @Override
    public AbstractBlock.Properties getBlockProperties() {
        return this.properties;
    }
}

