/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.network;

import flaxbeard.immersivepetroleum.common.network.INetMessage;
import flaxbeard.immersivepetroleum.common.network.MessageConsumeBoatFuel;
import flaxbeard.immersivepetroleum.common.network.MessageDebugSync;
import flaxbeard.immersivepetroleum.common.network.MessageProjectorSync;
import flaxbeard.immersivepetroleum.common.util.ResourceUtils;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class IPPacketHandler {
    public static final String NET_VERSION = "1";
    public static final SimpleChannel INSTANCE = NetworkRegistry.ChannelBuilder.named((ResourceLocation)ResourceUtils.ip("main")).networkProtocolVersion(() -> "1").serverAcceptedVersions("1"::equals).clientAcceptedVersions("1"::equals).simpleChannel();
    private static int id = 0;

    public static void preInit() {
        IPPacketHandler.registerMessage(MessageDebugSync.class, MessageDebugSync::new);
        IPPacketHandler.registerMessage(MessageConsumeBoatFuel.class, MessageConsumeBoatFuel::new);
        IPPacketHandler.registerMessage(MessageProjectorSync.class, MessageProjectorSync::new);
    }

    public static <T extends INetMessage> void registerMessage(Class<T> type, Function<PacketBuffer, T> decoder) {
        INSTANCE.registerMessage(id++, type, INetMessage::toBytes, decoder, (t, ctx) -> {
            t.process((Supplier<NetworkEvent.Context>)ctx);
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        });
    }

    public static <MSG> void sendToPlayer(PlayerEntity player, MSG message) {
        if (message == null || !(player instanceof ServerPlayerEntity)) {
            return;
        }
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), message);
    }

    public static <MSG> void sendToServer(MSG message) {
        if (message == null) {
            return;
        }
        INSTANCE.send(PacketDistributor.SERVER.noArg(), message);
    }

    public static <MSG> void sendToDimension(RegistryKey<World> dim, MSG message) {
        if (message == null) {
            return;
        }
        INSTANCE.send(PacketDistributor.DIMENSION.with(() -> dim), message);
    }

    public static <MSG> void sendAll(MSG message) {
        if (message == null) {
            return;
        }
        INSTANCE.send(PacketDistributor.ALL.noArg(), message);
    }
}

