/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.gui;

import flaxbeard.immersivepetroleum.api.crafting.CokerUnitRecipe;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidUtil;

public class IPSlot
extends Slot {
    public IPSlot(IInventory inventoryIn, int index, int xPosition, int yPosition) {
        super(inventoryIn, index, xPosition, yPosition);
    }

    public static class FluidContainer
    extends IPSlot {
        FluidFilter filter;

        public FluidContainer(IInventory inv, int id, int x, int y, FluidFilter filter) {
            super(inv, id, x, y);
            this.filter = filter;
        }

        public boolean func_75214_a(ItemStack itemStack) {
            LazyOptional handlerCap = FluidUtil.getFluidHandler((ItemStack)itemStack);
            return handlerCap.map(handler -> {
                if (handler.getTanks() <= 0) {
                    return false;
                }
                switch (this.filter) {
                    case FULL: {
                        return !handler.getFluidInTank(0).isEmpty();
                    }
                    case EMPTY: {
                        return handler.getFluidInTank(0).isEmpty();
                    }
                }
                return true;
            }).orElse(false);
        }

        public static enum FluidFilter {
            ANY,
            EMPTY,
            FULL;

        }
    }

    public static class CokerInput
    extends IPSlot {
        public CokerInput(Container container, IInventory inv, int id, int x, int y) {
            super(inv, id, x, y);
        }

        public boolean func_75214_a(ItemStack stack) {
            return !stack.func_190926_b() && CokerUnitRecipe.hasRecipeWithInput(stack, true);
        }
    }

    public static class ItemOutput
    extends IPSlot {
        public ItemOutput(IInventory inventoryIn, int index, int xPosition, int yPosition) {
            super(inventoryIn, index, xPosition, yPosition);
        }

        public boolean func_75214_a(ItemStack stack) {
            return false;
        }
    }
}

