/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.crafting.serializers;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import flaxbeard.immersivepetroleum.api.crafting.SulfurRecoveryRecipe;
import flaxbeard.immersivepetroleum.api.crafting.builders.DistillationRecipeBuilder;
import flaxbeard.immersivepetroleum.common.IPContent;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraftforge.fluids.FluidStack;

public class SulfurRecoveryRecipeSerializer
extends IERecipeSerializer<SulfurRecoveryRecipe> {
    public SulfurRecoveryRecipe readFromJson(ResourceLocation id, JsonObject json) {
        FluidStack output = ApiUtils.jsonDeserializeFluidStack((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
        FluidTagInput inputFluid0 = FluidTagInput.deserialize((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"input"));
        FluidTagInput inputFluid1 = null;
        if (json.has("secondary_input")) {
            inputFluid1 = FluidTagInput.deserialize((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"secondary_input"));
        }
        Tuple<ItemStack, Double> itemWithChance = DistillationRecipeBuilder.deserializeItemStackWithChance(json.get("secondary_result").getAsJsonObject());
        int energy = JSONUtils.func_151203_m((JsonObject)json, (String)"energy");
        int time = JSONUtils.func_151203_m((JsonObject)json, (String)"time");
        return new SulfurRecoveryRecipe(id, output, (ItemStack)itemWithChance.func_76341_a(), inputFluid0, inputFluid1, (Double)itemWithChance.func_76340_b(), energy, time);
    }

    public SulfurRecoveryRecipe read(ResourceLocation id, PacketBuffer buffer) {
        ItemStack outputItem = buffer.func_150791_c();
        double chance = buffer.readDouble();
        FluidStack output = buffer.readFluidStack();
        FluidTagInput inputFluid0 = FluidTagInput.read((PacketBuffer)buffer);
        FluidTagInput inputFluid1 = FluidTagInput.read((PacketBuffer)buffer);
        int energy = buffer.readInt();
        int time = buffer.readInt();
        return new SulfurRecoveryRecipe(id, output, outputItem, inputFluid0, inputFluid1, chance, energy, time);
    }

    public void write(PacketBuffer buffer, SulfurRecoveryRecipe recipe) {
        buffer.func_150788_a(recipe.outputItem);
        buffer.writeDouble(recipe.chance);
        buffer.writeFluidStack(recipe.output);
        recipe.inputFluid.write(buffer);
        recipe.inputFluidSecondary.write(buffer);
        buffer.writeInt(recipe.getTotalProcessEnergy());
        buffer.writeInt(recipe.getTotalProcessTime());
    }

    public ItemStack getIcon() {
        return new ItemStack((IItemProvider)IPContent.Multiblock.hydrotreater);
    }
}

