/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.client.model;

import com.google.common.collect.ImmutableList;
import flaxbeard.immersivepetroleum.common.entity.MotorboatEntity;
import java.util.Arrays;
import net.minecraft.client.renderer.entity.model.SegmentedModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModelMotorboat
extends SegmentedModel<MotorboatEntity> {
    private final ImmutableList<ModelRenderer> list;
    public ModelRenderer noWater;
    public ModelRenderer[] boatSides = new ModelRenderer[5];
    public ModelRenderer motor;
    public ModelRenderer propeller;
    public ModelRenderer propellerAssembly;
    public ModelRenderer icebreak;
    public ModelRenderer coreSampleBoat;
    public ModelRenderer coreSampleBoatDrill;
    public ModelRenderer tank;
    public ModelRenderer rudder1;
    public ModelRenderer rudder2;
    public ModelRenderer ruddersBase;
    public ModelRenderer[] paddles = new ModelRenderer[2];

    public ModelMotorboat() {
        this.boatSides[0] = new ModelRenderer((Model)this, 0, 0).func_78787_b(128, 64);
        this.boatSides[1] = new ModelRenderer((Model)this, 0, 19).func_78787_b(128, 64);
        this.boatSides[2] = new ModelRenderer((Model)this, 0, 27).func_78787_b(128, 64);
        this.boatSides[3] = new ModelRenderer((Model)this, 0, 35).func_78787_b(128, 64);
        this.boatSides[4] = new ModelRenderer((Model)this, 0, 43).func_78787_b(128, 64);
        this.boatSides[0].func_228301_a_(-14.0f, -9.0f, -3.0f, 28.0f, 16.0f, 3.0f, 0.0f);
        this.boatSides[0].func_78793_a(0.0f, 3.0f, 1.0f);
        this.boatSides[1].func_228301_a_(-13.0f, -7.0f, -1.0f, 18.0f, 6.0f, 2.0f, 0.0f);
        this.boatSides[1].func_78793_a(-15.0f, 4.0f, 4.0f);
        this.boatSides[2].func_228301_a_(-8.0f, -7.0f, -1.0f, 16.0f, 6.0f, 2.0f, 0.0f);
        this.boatSides[2].func_78793_a(15.0f, 4.0f, 0.0f);
        this.boatSides[3].func_228301_a_(-14.0f, -7.0f, -1.0f, 28.0f, 6.0f, 2.0f, 0.0f);
        this.boatSides[3].func_78793_a(0.0f, 4.0f, -9.0f);
        this.boatSides[4].func_228301_a_(-14.0f, -7.0f, -1.0f, 28.0f, 6.0f, 2.0f, 0.0f);
        this.boatSides[4].func_78793_a(0.0f, 4.0f, 9.0f);
        this.boatSides[0].field_78795_f = 1.5707964f;
        this.boatSides[1].field_78796_g = 4.712389f;
        this.boatSides[2].field_78796_g = 1.5707964f;
        this.boatSides[3].field_78796_g = (float)Math.PI;
        this.noWater = new ModelRenderer((Model)this, 0, 0).func_78787_b(128, 64);
        this.noWater.func_228301_a_(-14.0f, -9.0f, -3.0f, 28.0f, 16.0f, 3.0f, 0.0f);
        this.noWater.func_78793_a(0.0f, -3.0f, 1.0f);
        this.noWater.field_78795_f = 1.5707964f;
        this.refresh();
        this.paddles[0] = this.makePaddle(true);
        this.paddles[0].func_78793_a(3.0f, -5.0f, 9.0f);
        this.paddles[1] = this.makePaddle(false);
        this.paddles[1].func_78793_a(3.0f, -5.0f, -9.0f);
        this.paddles[1].field_78796_g = (float)Math.PI;
        this.paddles[0].field_78808_h = 0.19634955f;
        this.paddles[1].field_78808_h = 0.19634955f;
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(Arrays.asList(this.boatSides));
        builder.addAll(Arrays.asList(this.motor, this.propellerAssembly));
        this.list = builder.build();
    }

    public void refresh() {
        this.motor = new ModelRenderer((Model)this, 104, 0).func_78787_b(128, 64);
        this.motor.func_228301_a_(-19.0f, -8.0f, -3.0f, 6.0f, 5.0f, 6.0f, 0.0f);
        this.propellerAssembly = new ModelRenderer((Model)this, 96, 0).func_78787_b(128, 64);
        this.propellerAssembly.func_78793_a(-17.0f, 5.0f, 0.0f);
        this.propellerAssembly.func_228301_a_(-1.0f, -8.1f, -1.0f, 2.0f, 10.0f, 2.0f, 0.0f);
        ModelRenderer handle = new ModelRenderer((Model)this, 72, 0).func_78787_b(128, 64);
        handle.func_228300_a_(4.0f, -9.7f, -0.5f, 6.0f, 1.0f, 1.0f);
        handle.field_78795_f = 0.0f;
        handle.field_78808_h = (float)Math.toRadians(-5.0);
        this.propellerAssembly.func_78792_a(handle);
        this.propeller = new ModelRenderer((Model)this, 86, 0).func_78787_b(128, 64);
        this.propeller.func_228301_a_(-1.0f, -1.0f, -1.0f, 3.0f, 2.0f, 2.0f, 0.0f);
        this.propeller.func_78793_a(-3.0f, 0.0f, 0.0f);
        this.propellerAssembly.func_78792_a(this.propeller);
        ModelRenderer propeller1 = new ModelRenderer((Model)this, 90, 4).func_78787_b(128, 64);
        propeller1.func_228301_a_(0.0f, 0.0f, -1.0f, 1.0f, 4.0f, 2.0f, 0.0f);
        propeller1.field_78796_g = (float)Math.toRadians(15.0);
        this.propeller.func_78792_a(propeller1);
        ModelRenderer propeller2B = new ModelRenderer((Model)this, 90, 4).func_78787_b(128, 64);
        this.propeller.func_78792_a(propeller2B);
        propeller2B.field_78795_f = (float)Math.toRadians(120.0);
        ModelRenderer propeller2 = new ModelRenderer((Model)this, 90, 4).func_78787_b(128, 64);
        propeller2.func_228301_a_(0.0f, 0.0f, -1.0f, 1.0f, 4.0f, 2.0f, 0.0f);
        propeller2.field_78796_g = (float)Math.toRadians(15.0);
        propeller2B.func_78792_a(propeller2);
        ModelRenderer propeller3B = new ModelRenderer((Model)this, 90, 4).func_78787_b(128, 64);
        this.propeller.func_78792_a(propeller3B);
        propeller3B.field_78795_f = (float)Math.toRadians(240.0);
        ModelRenderer propeller3 = new ModelRenderer((Model)this, 90, 4).func_78787_b(128, 64);
        propeller3.func_228301_a_(0.0f, 0.0f, -1.0f, 1.0f, 4.0f, 2.0f, 0.0f);
        propeller3.field_78796_g = (float)Math.toRadians(15.0);
        propeller3B.func_78792_a(propeller3);
        this.icebreak = new ModelRenderer((Model)this, 34, 56).func_78787_b(128, 64);
        this.icebreak.func_228301_a_(16.0f, -2.0f, -2.0f, 7.0f, 4.0f, 4.0f, 0.0f);
        this.tank = new ModelRenderer((Model)this, 86, 24).func_78787_b(128, 64);
        this.tank.func_228301_a_(-14.0f, -2.0f, -8.0f, 5.0f, 5.0f, 16.0f, 0.0f);
        this.ruddersBase = new ModelRenderer((Model)this, 92, 29).func_78787_b(128, 64);
        this.ruddersBase.func_228301_a_(-18.0f, -3.0f, -8.0f, 2.0f, 6.0f, 3.0f, 0.0f);
        ModelRenderer ruddersBase2 = new ModelRenderer((Model)this, 92, 29).func_78787_b(128, 64);
        ruddersBase2.func_228301_a_(-18.0f, -3.0f, 6.0f, 2.0f, 6.0f, 3.0f, 0.0f);
        this.ruddersBase.func_78792_a(ruddersBase2);
        this.rudder1 = new ModelRenderer((Model)this, 112, 23).func_78787_b(128, 64);
        this.rudder1.func_78793_a(-15.0f, 3.0f, -6.5f);
        this.rudder1.func_228301_a_(-4.0f, 0.0f, -0.5f, 4.0f, 6.0f, 1.0f, 0.0f);
        this.rudder2 = new ModelRenderer((Model)this, 112, 23).func_78787_b(128, 64);
        this.rudder2.func_78793_a(-15.0f, 3.0f, 7.5f);
        this.rudder2.func_228301_a_(-4.0f, 0.0f, -0.5f, 4.0f, 6.0f, 1.0f, 0.0f);
        ModelRenderer pipe1 = new ModelRenderer((Model)this, 112, 38).func_78787_b(128, 64);
        pipe1.func_228301_a_(-13.0f, -3.0f, 4.0f, 1.0f, 1.0f, 1.0f, 0.0f);
        this.tank.func_78792_a(pipe1);
        ModelRenderer pipe2 = new ModelRenderer((Model)this, 116, 38).func_78787_b(128, 64);
        pipe2.func_228301_a_(-15.0f, -4.0f, 4.0f, 3.0f, 1.0f, 1.0f, 0.0f);
        this.tank.func_78792_a(pipe2);
        ModelRenderer pip3 = new ModelRenderer((Model)this, 112, 38).func_78787_b(128, 64);
        pip3.func_228301_a_(-15.0f, -4.0f, 3.0f, 1.0f, 1.0f, 1.0f, 0.0f);
        this.tank.func_78792_a(pip3);
        this.coreSampleBoat = new ModelRenderer((Model)this, 10, 0).func_78787_b(128, 64);
        this.coreSampleBoat.func_228301_a_(-10.0f, -1.0f, -13.0f, 4.0f, 2.0f, 2.0f, 0.0f);
        ModelRenderer core2 = new ModelRenderer((Model)this, 10, 0).func_78787_b(128, 64);
        core2.func_228301_a_(-11.0f, -2.0f, -14.0f, 1.0f, 4.0f, 4.0f, 0.0f);
        this.coreSampleBoat.func_78792_a(core2);
        ModelRenderer core3 = new ModelRenderer((Model)this, 10, 0).func_78787_b(128, 64);
        core3.func_228301_a_(-6.0f, -2.0f, -14.0f, 1.0f, 4.0f, 4.0f, 0.0f);
        this.coreSampleBoat.func_78792_a(core3);
        this.coreSampleBoatDrill = new ModelRenderer((Model)this, 10, 0).func_78787_b(128, 64);
        this.coreSampleBoatDrill.func_228301_a_(-3.0f, -8.0f, -16.0f, 6.0f, 18.0f, 6.0f, 0.0f);
        ModelRenderer iS1 = new ModelRenderer((Model)this, 56, 52).func_78787_b(128, 64);
        iS1.func_228301_a_(0.01f, -7.01f, -0.01f, 16.0f, 10.0f, 2.0f, 0.0f);
        iS1.func_78793_a(26.0f, 3.0f, 0.0f);
        iS1.field_78796_g = (float)Math.toRadians(225.0);
        this.icebreak.func_78792_a(iS1);
        ModelRenderer iS1T = new ModelRenderer((Model)this, 100, 45).func_78787_b(128, 64);
        iS1T.func_228301_a_(4.0f, 0.0f, -2.0f, 12.0f, 5.0f, 2.0f, 0.0f);
        iS1T.func_78793_a(0.0f, -7.0f, 0.0f);
        iS1T.field_78795_f = (float)Math.toRadians(157.0);
        iS1.func_78792_a(iS1T);
        ModelRenderer iS2 = new ModelRenderer((Model)this, 56, 52).func_78787_b(128, 64);
        iS2.func_228301_a_(0.0f, -7.0f, -2.0f, 16.0f, 10.0f, 2.0f, 0.0f);
        iS2.func_78793_a(26.0f, 3.0f, 0.0f);
        iS2.field_78796_g = (float)Math.toRadians(135.0);
        this.icebreak.func_78792_a(iS2);
        ModelRenderer iS2T = new ModelRenderer((Model)this, 100, 45).func_78787_b(128, 64);
        iS2T.func_228301_a_(4.0f, 0.0f, 0.0f, 12.0f, 5.0f, 2.0f, 0.0f);
        iS2T.func_78793_a(0.0f, -7.0f, 0.0f);
        iS2T.field_78795_f = (float)Math.toRadians(203.0);
        iS2.func_78792_a(iS2T);
    }

    ModelRenderer makePaddle(boolean left) {
        ModelRenderer model = new ModelRenderer((Model)this, 62, left ? 2 : 22).func_78787_b(128, 64);
        model.func_228300_a_(-1.0f, 0.0f, -5.0f, 2.0f, 2.0f, 18.0f);
        model.func_228300_a_(left ? -1.001f : 0.001f, -3.0f, 8.0f, 1.0f, 6.0f, 7.0f);
        return model;
    }

    public void setRotationAngles(MotorboatEntity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        MotorboatEntity boatEntity = entityIn;
        this.setPaddleRotationAngles(boatEntity, 0, limbSwing, boatEntity.isEmergency());
        this.setPaddleRotationAngles(boatEntity, 1, limbSwing, boatEntity.isEmergency());
    }

    public void setPaddleRotationAngles(BoatEntity boat, int paddle, float limbSwing, boolean rowing) {
        if (rowing) {
            float f = boat.func_184448_a(paddle, limbSwing);
            ModelRenderer model = this.paddles[paddle];
            model.field_78795_f = (float)MathHelper.func_151238_b((double)-1.0471975803375244, (double)-0.2617993950843811, (double)((MathHelper.func_76126_a((float)(-f)) + 1.0f) / 2.0f));
            model.field_78796_g = (float)MathHelper.func_151238_b((double)-0.7853981852531433, (double)0.7853981852531433, (double)((MathHelper.func_76126_a((float)(-f + 1.0f)) + 1.0f) / 2.0f));
            model.func_78793_a(3.0f, -5.0f, 9.0f);
            if (paddle == 1) {
                model.func_78793_a(3.0f, -5.0f, -9.0f);
                model.field_78796_g = (float)Math.PI - model.field_78796_g;
            }
        } else {
            ModelRenderer model = this.paddles[paddle];
            model.field_78795_f = (float)Math.toRadians(-25.0);
            model.field_78796_g = (float)Math.toRadians(-90.0);
            model.func_78793_a(3.0f, -2.0f, 11.0f);
            if (paddle == 1) {
                model.func_78793_a(3.0f, -2.0f, -11.0f);
                model.field_78796_g = (float)Math.PI - model.field_78796_g;
            }
        }
    }

    public Iterable<ModelRenderer> func_225601_a_() {
        return this.list;
    }

    public ModelRenderer noWaterRenderer() {
        return this.noWater;
    }
}

