/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.client;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.stream.Collectors;
import org.lwjgl.opengl.ARBShaderObjects;

public class ShaderUtil {
    private static final int VERT = 35633;
    private static final int FRAG = 35632;
    public static int alpha = -1;

    public static void alpha_static(float av, float ticks) {
        if (alpha == -1) {
            alpha = ShaderUtil.createShader(null, "/assets/immersivepetroleum/shaders/alpha.frag");
        }
        if (alpha > 0) {
            ARBShaderObjects.glUseProgramObjectARB((int)alpha);
            int a = ARBShaderObjects.glGetUniformLocationARB((int)alpha, (CharSequence)"alpha");
            int b = ARBShaderObjects.glGetUniformLocationARB((int)alpha, (CharSequence)"time");
            ARBShaderObjects.glUniform1fARB((int)a, (float)av);
            ARBShaderObjects.glUniform1fARB((int)b, (float)ticks);
        }
    }

    public static void releaseShader() {
        if (alpha > 0) {
            ARBShaderObjects.glUseProgramObjectARB((int)0);
        }
    }

    private static int createShader(String vert, String frag) {
        int program;
        int fragid = 0;
        int vertid = 0;
        if (frag != null) {
            fragid = ShaderUtil.createShader(frag, 35632);
        }
        if (vert != null) {
            vertid = ShaderUtil.createShader(vert, 35633);
        }
        if ((program = ARBShaderObjects.glCreateProgramObjectARB()) == 0) {
            return 0;
        }
        if (frag != null) {
            ARBShaderObjects.glAttachObjectARB((int)program, (int)fragid);
        }
        if (vert != null) {
            ARBShaderObjects.glAttachObjectARB((int)program, (int)vertid);
        }
        ARBShaderObjects.glLinkProgramARB((int)program);
        if (ARBShaderObjects.glGetObjectParameteriARB((int)program, (int)35714) == 0) {
            System.out.println("BAD: " + ShaderUtil.getLogInfo(program));
            return 0;
        }
        return program;
    }

    private static int createShader(String filename, int shaderType) {
        int shader = 0;
        try {
            shader = ARBShaderObjects.glCreateShaderObjectARB((int)shaderType);
            if (shader == 0) {
                return 0;
            }
            ARBShaderObjects.glShaderSourceARB((int)shader, (CharSequence)ShaderUtil.readFileAsString(filename));
            ARBShaderObjects.glCompileShaderARB((int)shader);
            if (ARBShaderObjects.glGetObjectParameteriARB((int)shader, (int)35713) == 0) {
                throw new RuntimeException("Error creating shader: " + ShaderUtil.getLogInfo(shader));
            }
            return shader;
        }
        catch (Exception e) {
            ARBShaderObjects.glDeleteObjectARB((int)shader);
            e.printStackTrace();
            return -1;
        }
    }

    private static String readFileAsString(String filename) throws Exception {
        InputStream in = ShaderUtil.class.getResourceAsStream(filename);
        if (in == null) {
            return "";
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));){
            String string = reader.lines().collect(Collectors.joining("\n"));
            return string;
        }
    }

    private static String getLogInfo(int obj) {
        return ARBShaderObjects.glGetInfoLogARB((int)obj, (int)ARBShaderObjects.glGetObjectParameteriARB((int)obj, (int)35716));
    }
}

