/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.api;

import com.google.common.base.Preconditions;
import flaxbeard.immersivepetroleum.common.util.ResourceUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.block.Block;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;

public class IPTags {
    private static final Map<ITag.INamedTag<Block>, ITag.INamedTag<Item>> toItemTag = new HashMap<ITag.INamedTag<Block>, ITag.INamedTag<Item>>();

    public static ITag.INamedTag<Item> getItemTag(ITag.INamedTag<Block> blockTag) {
        Preconditions.checkArgument((boolean)toItemTag.containsKey(blockTag));
        return toItemTag.get(blockTag);
    }

    private static ITag.INamedTag<Block> createBlockTag(ResourceLocation name) {
        ITag.INamedTag<Block> blockTag = IPTags.createBlockWrapper(name);
        toItemTag.put(blockTag, IPTags.createItemWrapper(name));
        return blockTag;
    }

    public static void forAllBlocktags(BiConsumer<ITag.INamedTag<Block>, ITag.INamedTag<Item>> out) {
        for (Map.Entry<ITag.INamedTag<Block>, ITag.INamedTag<Item>> entry : toItemTag.entrySet()) {
            out.accept(entry.getKey(), entry.getValue());
        }
    }

    private static ITag.INamedTag<Block> createBlockWrapper(ResourceLocation name) {
        return BlockTags.func_199894_a((String)name.toString());
    }

    private static ITag.INamedTag<Item> createItemWrapper(ResourceLocation name) {
        return ItemTags.func_199901_a((String)name.toString());
    }

    private static ITag.INamedTag<Fluid> createFluidWrapper(ResourceLocation name) {
        return FluidTags.func_206956_a((String)name.toString());
    }

    static /* synthetic */ ITag.INamedTag access$000(ResourceLocation x0) {
        return IPTags.createBlockTag(x0);
    }

    static /* synthetic */ ITag.INamedTag access$100(ResourceLocation x0) {
        return IPTags.createItemWrapper(x0);
    }

    static /* synthetic */ ITag.INamedTag access$200(ResourceLocation x0) {
        return IPTags.createFluidWrapper(x0);
    }

    public static class Utility {
        public static final ITag.INamedTag<Fluid> burnableInFlarestack = IPTags.access$200(ResourceUtils.ip("burnable_in_flarestack"));
    }

    public static class Fluids {
        public static final ITag.INamedTag<Fluid> crudeOil = IPTags.access$200(ResourceUtils.forge("crude_oil"));
        public static final ITag.INamedTag<Fluid> diesel = IPTags.access$200(ResourceUtils.forge("diesel"));
        public static final ITag.INamedTag<Fluid> diesel_sulfur = IPTags.access$200(ResourceUtils.forge("diesel_sulfur"));
        public static final ITag.INamedTag<Fluid> gasoline = IPTags.access$200(ResourceUtils.forge("gasoline"));
        public static final ITag.INamedTag<Fluid> lubricant = IPTags.access$200(ResourceUtils.forge("lubricant"));
        public static final ITag.INamedTag<Fluid> napalm = IPTags.access$200(ResourceUtils.forge("napalm"));
    }

    public static class Items {
        public static final ITag.INamedTag<Item> bitumen = IPTags.access$100(ResourceUtils.forge("bitumen"));
        public static final ITag.INamedTag<Item> petcoke = IPTags.access$100(ResourceUtils.forge("coal_petcoke"));
        public static final ITag.INamedTag<Item> petcokeDust = IPTags.access$100(ResourceUtils.forge("dusts/coal_petcoke"));
        public static final ITag.INamedTag<Item> petcokeStorage = IPTags.access$100(ResourceUtils.forge("storage_blocks/coal_petcoke"));
    }

    public static class Blocks {
        public static final ITag.INamedTag<Block> asphalt = IPTags.access$000(ResourceUtils.forge("asphalt"));
        public static final ITag.INamedTag<Block> petcoke = IPTags.access$000(ResourceUtils.forge("storage_blocks/petcoke"));
    }
}

