/*
 * Decompiled with CFR 0.152.
 */
package malte0811.modelsplitter;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import malte0811.modelsplitter.SplitModel;
import malte0811.modelsplitter.math.ModelSplitterVec3i;
import malte0811.modelsplitter.math.Vec3d;
import malte0811.modelsplitter.model.OBJModel;

public class ClumpedModel<Texture> {
    private final Map<ModelSplitterVec3i, OBJModel<Texture>> clumpedParts;

    public ClumpedModel(SplitModel<Texture> splitModel, Set<ModelSplitterVec3i> parts) {
        Preconditions.checkArgument((!parts.isEmpty() ? 1 : 0) != 0);
        HashMap<ModelSplitterVec3i, OBJModel> clumpedParts = new HashMap<ModelSplitterVec3i, OBJModel>();
        for (Map.Entry<ModelSplitterVec3i, OBJModel<Texture>> splitPart : splitModel.getParts().entrySet()) {
            ModelSplitterVec3i originalTarget;
            ModelSplitterVec3i target = originalTarget = splitPart.getKey();
            OBJModel<Texture> translatedModel = splitPart.getValue();
            if (!parts.contains(target)) {
                int optDist = Integer.MAX_VALUE;
                for (ModelSplitterVec3i candidate : parts) {
                    int currentDist = candidate.distanceSq(originalTarget);
                    if (currentDist >= optDist) continue;
                    optDist = currentDist;
                    target = candidate;
                }
                ModelSplitterVec3i translatedBy = originalTarget.subtract(target);
                translatedModel = translatedModel.translate(new Vec3d(translatedBy));
            }
            clumpedParts.merge(target, translatedModel, OBJModel::union);
        }
        this.clumpedParts = ImmutableMap.copyOf(clumpedParts);
    }

    public Map<ModelSplitterVec3i, OBJModel<Texture>> getClumpedParts() {
        return this.clumpedParts;
    }
}

