/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.lib.manual.gui;

import blusunrize.lib.manual.ManualEntry;
import blusunrize.lib.manual.ManualUtils;
import blusunrize.lib.manual.Tree;
import blusunrize.lib.manual.gui.ManualScreen;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.StringTextComponent;

public class ClickableList
extends Button {
    private String[] headers;
    private boolean[] isCategory;
    @Nonnull
    private List<Tree.AbstractNode<ResourceLocation, ManualEntry>> nodes = new ArrayList<Tree.AbstractNode<ResourceLocation, ManualEntry>>();
    private float textScale;
    private final Consumer<Tree.AbstractNode<ResourceLocation, ManualEntry>> handler;
    private int offset;
    private int maxOffset;
    private final int perPage;
    private ManualScreen gui;

    ClickableList(ManualScreen gui, int x, int y, int w, int h, float textScale, @Nonnull List<Tree.AbstractNode<ResourceLocation, ManualEntry>> nodes, Consumer<Tree.AbstractNode<ResourceLocation, ManualEntry>> handler) {
        super(x, y, w, h, StringTextComponent.field_240750_d_, btn -> {});
        this.gui = gui;
        this.textScale = textScale;
        this.handler = handler;
        this.perPage = (h - 8) / this.getFontHeight();
        this.setEntries(nodes);
    }

    int getFontHeight() {
        Objects.requireNonNull(this.gui.manual.fontRenderer());
        return (int)(9.0f * this.textScale);
    }

    public void func_230430_a_(MatrixStack transform, int mx, int my, float partialTicks) {
        if (!this.field_230694_p_) {
            return;
        }
        FontRenderer fr = this.gui.manual.fontRenderer();
        int mmY = my - this.field_230691_m_;
        transform.func_227860_a_();
        transform.func_227862_a_(this.textScale, this.textScale, this.textScale);
        transform.func_227861_a_((double)((float)this.field_230690_l_ / this.textScale), (double)((float)this.field_230691_m_ / this.textScale), 0.0);
        this.field_230692_n_ = mx >= this.field_230690_l_ && mx < this.field_230690_l_ + this.field_230688_j_ && my >= this.field_230691_m_ && my < this.field_230691_m_ + this.field_230689_k_;
        for (int i = 0; i < Math.min(this.perPage, this.headers.length); ++i) {
            int j;
            boolean currEntryHovered;
            int col = this.gui.manual.getTextColour();
            boolean bl = currEntryHovered = this.field_230692_n_ && mmY >= i * this.getFontHeight() && mmY < (i + 1) * this.getFontHeight();
            if (currEntryHovered) {
                col = this.gui.manual.getHighlightColour();
            }
            if (i != 0) {
                transform.func_227861_a_(0.0, (double)this.getFontHeight(), 0.0);
            }
            if ((j = this.offset + i) > this.headers.length - 1) {
                j = this.headers.length - 1;
            }
            String s = this.headers[j];
            if (this.isCategory[j]) {
                ManualUtils.bindTexture(this.gui.texture);
                RenderSystem.enableBlend();
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                this.func_238474_b_(transform, 0, 0, 11, 226 + (currEntryHovered ? 20 : 0), 5, 10);
            }
            fr.func_238421_b_(transform, s, this.isCategory[j] ? 7.0f : 0.0f, 0.0f, col);
        }
        transform.func_227862_a_(1.0f / this.textScale, 1.0f / this.textScale, 1.0f / this.textScale);
        transform.func_227865_b_();
        if (this.maxOffset > 0) {
            int minVisibleBlack = 0x1B000000;
            int mainBarBlack = 0x28000000;
            float totalHeight = this.maxOffset * this.getFontHeight() + this.field_230689_k_;
            float heightTopRel = (float)(this.offset * this.getFontHeight()) / totalHeight;
            float heightBottomRel = (float)(this.offset * this.getFontHeight() + this.field_230689_k_) / totalHeight;
            int heightTopAbs = (int)(heightTopRel * (float)this.field_230689_k_);
            int heightBottomAbs = (int)(heightBottomRel * (float)this.field_230689_k_);
            ClickableList.func_238467_a_((MatrixStack)transform, (int)(this.field_230690_l_ + this.field_230688_j_), (int)this.field_230691_m_, (int)(this.field_230690_l_ + this.field_230688_j_ + 8), (int)(this.field_230691_m_ + this.field_230689_k_), (int)0x1B000000);
            ClickableList.func_238467_a_((MatrixStack)transform, (int)(this.field_230690_l_ + this.field_230688_j_ + 1), (int)(this.field_230691_m_ + heightTopAbs), (int)(this.field_230690_l_ + this.field_230688_j_ + 7), (int)(this.field_230691_m_ + heightBottomAbs), (int)0x28000000);
        }
    }

    public boolean func_231043_a_(double p_mouseScrolled_1_, double p_mouseScrolled_3_, double amount) {
        if (amount < 0.0 && this.offset < this.maxOffset) {
            ++this.offset;
            return true;
        }
        if (amount > 0.0 && this.offset > 0) {
            --this.offset;
            return true;
        }
        return false;
    }

    @Nullable
    public Tree.AbstractNode<ResourceLocation, ManualEntry> getSelected(double mx, double my) {
        if (!super.func_230992_c_(mx, my)) {
            return null;
        }
        double mmY = my - (double)this.field_230691_m_;
        for (int i = 0; i < Math.min(this.perPage, this.headers.length); ++i) {
            if (!(mmY >= (double)(i * this.getFontHeight())) || !(mmY < (double)((i + 1) * this.getFontHeight()))) continue;
            return this.nodes.get(this.offset + i);
        }
        return null;
    }

    public void func_230982_a_(double mx, double my) {
        this.handler.accept(this.getSelected(mx, my));
    }

    protected boolean func_230992_c_(double mx, double my) {
        return this.getSelected(mx, my) != null;
    }

    public void setEntries(List<Tree.AbstractNode<ResourceLocation, ManualEntry>> nodes) {
        this.nodes = nodes;
        this.headers = new String[nodes.size()];
        this.isCategory = new boolean[nodes.size()];
        for (int i = 0; i < nodes.size(); ++i) {
            this.headers[i] = ManualUtils.getTitleForNode(nodes.get(i), this.gui.manual);
            this.isCategory[i] = !nodes.get(i).isLeaf();
        }
        this.maxOffset = this.perPage < this.headers.length ? this.headers.length - this.perPage : 0;
        this.field_230689_k_ = this.getFontHeight() * Math.min(this.perPage, this.headers.length);
    }

    public int func_238483_d_() {
        return this.field_230689_k_;
    }
}

