/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.lib.manual;

import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.ManualUtils;
import blusunrize.lib.manual.SpecialManualElements;
import blusunrize.lib.manual.gui.ManualScreen;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;

public class ManualElementImage
extends SpecialManualElements {
    private ManualImage[] images;
    int size;

    public ManualElementImage(ManualInstance helper, ManualImage ... images) {
        super(helper);
        this.images = images;
        for (ManualImage image : images) {
            this.size += image.vSize + 5;
        }
    }

    @Override
    public void onOpened(ManualScreen gui, int x, int y, List<Button> pageButtons) {
        super.onOpened(gui, x, y, pageButtons);
    }

    @Override
    public void render(MatrixStack transform, ManualScreen gui, int x, int y, int mx, int my) {
        int yOff = 0;
        for (ManualImage image1 : this.images) {
            int xOff = 60 - image1.uSize / 2;
            gui.func_238468_a_(transform, x + xOff - 2, y + yOff - 2, x + xOff + image1.uSize + 2, y + yOff + image1.vSize + 2, -1398964, -610215);
            gui.func_238468_a_(transform, x + xOff - 1, y + yOff - 1, x + xOff + image1.uSize + 1, y + yOff + image1.vSize + 1, -3764666, -4290492);
            yOff += image1.vSize + 5;
        }
        yOff = 0;
        IRenderTypeBuffer.Impl buffers = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        for (ManualImage image : this.images) {
            int xOff = 60 - image.uSize / 2;
            ManualUtils.drawTexturedRect(transform, (IRenderTypeBuffer)buffers, image.resource, x + xOff, y + yOff, image.uSize, image.vSize, (float)image.uMin / 256.0f, (float)(image.uMin + image.uSize) / 256.0f, (float)image.vMin / 256.0f, (float)(image.vMin + image.vSize) / 256.0f);
            yOff += image.vSize + 5;
        }
        buffers.func_228461_a_();
    }

    @Override
    public boolean listForSearch(String searchTag) {
        return false;
    }

    @Override
    public int getPixelsTaken() {
        return this.size;
    }

    public static class ManualImage {
        ResourceLocation resource;
        int uMin;
        int uSize;
        int vMin;
        int vSize;

        public ManualImage(ResourceLocation resource, int uMin, int uSize, int vMin, int vSize) {
            this.resource = resource;
            this.uMin = uMin;
            this.uSize = uSize;
            this.vMin = vMin;
            this.vSize = vSize;
        }
    }
}

