/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.fakeworld;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.FluidState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.EmptyChunk;
import net.minecraft.world.gen.feature.template.Template;

public class TemplateChunk
extends EmptyChunk {
    private final Map<BlockPos, Template.BlockInfo> blocksInChunk;
    private final Map<BlockPos, TileEntity> tiles;
    private final Predicate<BlockPos> shouldShow;

    public TemplateChunk(World worldIn, ChunkPos chunkPos, List<Template.BlockInfo> blocksInChunk, Predicate<BlockPos> shouldShow) {
        super(worldIn, chunkPos);
        this.shouldShow = shouldShow;
        this.blocksInChunk = new HashMap<BlockPos, Template.BlockInfo>();
        this.tiles = new HashMap<BlockPos, TileEntity>();
        for (Template.BlockInfo info : blocksInChunk) {
            TileEntity tile;
            this.blocksInChunk.put(info.field_186242_a, info);
            if (info.field_186244_c == null || (tile = TileEntity.func_235657_b_((BlockState)info.field_186243_b, (CompoundNBT)info.field_186244_c)) == null) continue;
            tile.func_226984_a_(worldIn, info.field_186242_a);
            this.tiles.put(info.field_186242_a, tile);
        }
    }

    @Nonnull
    public BlockState func_180495_p(@Nonnull BlockPos pos) {
        Template.BlockInfo result;
        if (this.shouldShow.test(pos) && (result = this.blocksInChunk.get(pos)) != null) {
            return result.field_186243_b;
        }
        return Blocks.field_201940_ji.func_176223_P();
    }

    @Nonnull
    public FluidState func_204610_c(@Nonnull BlockPos pos) {
        return this.func_180495_p(pos).func_204520_s();
    }

    @Nullable
    public TileEntity func_177424_a(@Nonnull BlockPos pos, @Nonnull Chunk.CreateEntityType creationMode) {
        if (!this.shouldShow.test(pos)) {
            return null;
        }
        return this.tiles.get(pos);
    }
}

