/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.crafttweaker.managers;

import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.MixerRecipe;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.CrTIngredientUtil;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.actions.AbstractActionGenericRemoveRecipe;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.actions.ActionAddRecipeCustomOutput;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.actions.IAction;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.brackets.CommandStringDisplayable;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.item.IIngredientWithAmount;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.impl.tag.MCTag;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="mods/immersiveengineering/Mixer")
@ZenCodeType.Name(value="mods.immersiveengineering.Mixer")
public class MixerRecipeManager
implements IRecipeManager {
    public IRecipeType<MixerRecipe> getRecipeType() {
        return MixerRecipe.TYPE;
    }

    public void removeRecipe(IItemStack output) {
        throw new UnsupportedOperationException("Cannot remove a Mixer recipe by Item output because Mixer Recipes have no Item output!");
    }

    @ZenCodeType.Method
    public void removeRecipe(final IFluidStack fluidStack) {
        AbstractActionGenericRemoveRecipe<MixerRecipe> action = new AbstractActionGenericRemoveRecipe<MixerRecipe>((IRecipeManager)this, (CommandStringDisplayable)fluidStack){

            @Override
            public boolean shouldRemove(MixerRecipe recipe) {
                return recipe.fluidOutput.isFluidStackIdentical(fluidStack.getInternal());
            }
        };
        CraftTweakerAPI.apply((IAction)action);
    }

    @ZenCodeType.Method
    public void removeRecipe(final Fluid fluid) {
        AbstractActionGenericRemoveRecipe<MixerRecipe> action = new AbstractActionGenericRemoveRecipe<MixerRecipe>((IRecipeManager)this, fluid){

            @Override
            public boolean shouldRemove(MixerRecipe recipe) {
                return fluid.func_207187_a(recipe.fluidOutput.getFluid());
            }
        };
        CraftTweakerAPI.apply((IAction)action);
    }

    @ZenCodeType.Method
    public void addRecipe(String recipePath, MCTag<Fluid> fluidInput, IIngredientWithAmount[] inputItems, int energy, Fluid output, int amount) {
        ResourceLocation resourceLocation = new ResourceLocation("crafttweaker", recipePath);
        FluidTagInput fluidTagInput = CrTIngredientUtil.getFluidTagInput(fluidInput, amount);
        IngredientWithSize[] ingredientsWithSize = CrTIngredientUtil.getIngredientsWithSize(inputItems);
        FluidStack outputFluidStack = new FluidStack(output, amount);
        MixerRecipe recipe = new MixerRecipe(resourceLocation, outputFluidStack, fluidTagInput, ingredientsWithSize, energy);
        CraftTweakerAPI.apply((IAction)new ActionAddRecipeCustomOutput((IRecipeManager)this, recipe, outputFluidStack));
    }
}

