/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.crafttweaker.managers;

import blusunrize.immersiveengineering.api.crafting.CrusherRecipe;
import blusunrize.immersiveengineering.api.crafting.StackWithChance;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.CrTIngredientUtil;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.actions.AbstractActionRemoveMultipleOutputs;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.actions.IAction;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.impl.actions.recipes.ActionAddRecipe;
import com.blamejared.crafttweaker.impl.item.MCWeightedItemStack;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="mods/immersiveengineering/Crusher")
@ZenCodeType.Name(value="mods.immersiveengineering.Crusher")
public class CrusherRecipeManager
implements IRecipeManager {
    public IRecipeType<CrusherRecipe> getRecipeType() {
        return CrusherRecipe.TYPE;
    }

    public void removeRecipe(IItemStack output) {
        this.removeRecipe((IIngredient)output);
    }

    @ZenCodeType.Method
    public void removeRecipe(IIngredient output) {
        CraftTweakerAPI.apply((IAction)new AbstractActionRemoveMultipleOutputs<CrusherRecipe>((IRecipeManager)this, output){

            @Override
            public List<ItemStack> getAllOutputs(CrusherRecipe recipe) {
                ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
                itemStacks.add(recipe.output);
                for (StackWithChance secondaryOutput : recipe.secondaryOutputs) {
                    itemStacks.add(secondaryOutput.getStack());
                }
                return itemStacks;
            }
        });
    }

    @ZenCodeType.Method
    public void addRecipe(String recipePath, IIngredient input, int energy, IItemStack mainOutput, MCWeightedItemStack ... additionalOutputs) {
        ResourceLocation resourceLocation = new ResourceLocation("crafttweaker", recipePath);
        ItemStack result = mainOutput.getInternal();
        Ingredient ingredient = input.asVanillaIngredient();
        CrusherRecipe recipe = new CrusherRecipe(resourceLocation, result, ingredient, energy);
        for (MCWeightedItemStack additionalOutput : additionalOutputs) {
            StackWithChance stackWithChance = CrTIngredientUtil.getStackWithChance(additionalOutput);
            recipe.addToSecondaryOutput(stackWithChance);
        }
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, (IRecipe)recipe, null));
    }
}

