/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.gui.sync;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.network.PacketBuffer;

public class GenericDataSerializers {
    private static final List<DataSerializer<?>> SERIALIZERS = new ArrayList();
    public static final DataSerializer<Integer> INT32 = GenericDataSerializers.register(PacketBuffer::func_150792_a, PacketBuffer::func_150787_b);

    private static <T> DataSerializer<T> register(Function<PacketBuffer, T> read, BiConsumer<PacketBuffer, T> write) {
        DataSerializer<T> serializer = new DataSerializer<T>(read, write, SERIALIZERS.size());
        SERIALIZERS.add(serializer);
        return serializer;
    }

    public static DataPair<?> read(PacketBuffer buffer) {
        DataSerializer<?> serializer = SERIALIZERS.get(buffer.func_150792_a());
        return serializer.read(buffer);
    }

    public static final class DataSerializer<T> {
        private final Function<PacketBuffer, T> read;
        private final BiConsumer<PacketBuffer, T> write;
        private final int id;

        public DataSerializer(Function<PacketBuffer, T> read, BiConsumer<PacketBuffer, T> write, int id) {
            this.read = read;
            this.write = write;
            this.id = id;
        }

        public DataPair<T> read(PacketBuffer from) {
            return new DataPair<T>(this, this.read.apply(from));
        }
    }

    public static final class DataPair<T> {
        private final DataSerializer<T> serializer;
        private final T data;

        public DataPair(DataSerializer<T> serializer, T data) {
            this.serializer = serializer;
            this.data = data;
        }

        public void write(PacketBuffer to) {
            to.func_150787_b(((DataSerializer)this.serializer).id);
            ((DataSerializer)this.serializer).write.accept(to, this.data);
        }

        public T data() {
            return this.data;
        }
    }
}

