/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.api.crafting.BottlingMachineRecipe;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.MixerRecipe;
import blusunrize.immersiveengineering.common.crafting.PotionHelper;
import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.immersiveengineering.common.util.fluids.PotionFluid;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class PotionRecipeGenerators {
    public static final Set<String> BLACKLIST = new HashSet<String>();

    public static List<MixerRecipe> initPotionRecipes() {
        HashMap recipes = new HashMap();
        PotionHelper.applyToAllPotionRecipes((out, in, reagent) -> PotionRecipeGenerators.registerPotionRecipe(out, in, reagent, recipes));
        return recipes.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public static List<BottlingMachineRecipe> getPotionBottlingRecipes() {
        HashMap<Potion, BottlingMachineRecipe> recipes = new HashMap<Potion, BottlingMachineRecipe>();
        Function<Potion, BottlingMachineRecipe> toRecipe = potion -> new BottlingMachineRecipe(potion.getRegistryName(), PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)potion), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151069_bo}), PotionHelper.getFluidTagForType(potion, 250));
        PotionHelper.applyToAllPotionRecipes((out, in, reagent) -> {
            if (!recipes.containsKey(out)) {
                recipes.put(out, (BottlingMachineRecipe)toRecipe.apply(out));
            }
        });
        recipes.put(Potions.field_185230_b, toRecipe.apply(Potions.field_185230_b));
        IELogger.logger.info("Recipes for potions: " + recipes.keySet().stream().map(ForgeRegistryEntry::getRegistryName).filter(Objects::nonNull).map(ResourceLocation::toString).collect(Collectors.joining(", ")));
        return new ArrayList<BottlingMachineRecipe>(recipes.values());
    }

    public static void registerPotionRecipe(Potion output, Potion input, IngredientWithSize reagent, Map<Potion, List<MixerRecipe>> all) {
        if (!BLACKLIST.contains(output.getRegistryName().toString())) {
            List existing = all.computeIfAbsent(output, p -> new ArrayList());
            ResourceLocation baseName = output.getRegistryName();
            ResourceLocation name = new ResourceLocation(baseName.func_110624_b(), baseName.func_110623_a() + "_" + existing.size());
            MixerRecipe recipe = new MixerRecipe(name, PotionFluid.getFluidStackForType(output, 1000), PotionHelper.getFluidTagForType(input, 1000), new IngredientWithSize[]{reagent}, 6400);
            existing.add(recipe);
        }
    }
}

