/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.common.items.BulletItem;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.RecipeSerializers;
import javax.annotation.Nonnull;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.PotionItem;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemHandlerHelper;

public class PotionBulletFillRecipe
extends SpecialRecipe {
    public PotionBulletFillRecipe(ResourceLocation resourceLocation) {
        super(resourceLocation);
    }

    public boolean matches(CraftingInventory inv, @Nonnull World world) {
        boolean hasBullet = false;
        boolean hasPotion = false;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stackInSlot = inv.func_70301_a(i);
            if (stackInSlot.func_190926_b()) continue;
            if (this.isPotionBullet(stackInSlot)) {
                if (hasBullet) {
                    return false;
                }
                hasBullet = true;
                continue;
            }
            if (stackInSlot.func_77973_b() instanceof PotionItem) {
                if (hasPotion) {
                    return false;
                }
                hasPotion = true;
                continue;
            }
            return false;
        }
        return hasBullet && hasPotion;
    }

    @Nonnull
    public ItemStack assemble(CraftingInventory inv) {
        ItemStack bullet = ItemStack.field_190927_a;
        ItemStack potion = ItemStack.field_190927_a;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stackInSlot = inv.func_70301_a(i);
            if (stackInSlot.func_190926_b()) continue;
            if (bullet.func_190926_b() && this.isPotionBullet(stackInSlot)) {
                bullet = stackInSlot;
                continue;
            }
            if (!potion.func_190926_b() || !(stackInSlot.func_77973_b() instanceof PotionItem)) continue;
            potion = stackInSlot;
        }
        ItemStack newBullet = ItemHandlerHelper.copyStackWithSize((ItemStack)bullet, (int)1);
        ItemNBTHelper.setItemStack(newBullet, "potion", potion.func_77946_l());
        return newBullet;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)RecipeSerializers.POTION_BULLET_FILL.get();
    }

    private boolean isPotionBullet(ItemStack stack) {
        return stack.func_77973_b() instanceof BulletItem && ((BulletItem)stack.func_77973_b()).getType() == BulletHandler.getBullet(BulletItem.POTION);
    }
}

