/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.items.IEItems;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.RecipeSerializers;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class EarmuffsRecipe
implements ICraftingRecipe {
    private final ResourceLocation id;

    public EarmuffsRecipe(ResourceLocation rl) {
        this.id = rl;
    }

    public boolean func_192399_d() {
        return true;
    }

    public boolean matches(CraftingInventory inv, @Nonnull World worldIn) {
        ItemStack earmuffs = ItemStack.field_190927_a;
        ItemStack armor = ItemStack.field_190927_a;
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stackInSlot = inv.func_70301_a(i);
            if (stackInSlot.func_190926_b()) continue;
            if (earmuffs.func_190926_b() && IEItems.Misc.earmuffs.equals(stackInSlot.func_77973_b())) {
                earmuffs = stackInSlot;
                continue;
            }
            if (armor.func_190926_b() && stackInSlot.func_77973_b() instanceof ArmorItem && ((ArmorItem)stackInSlot.func_77973_b()).func_185083_B_() == EquipmentSlotType.HEAD && !IEItems.Misc.earmuffs.equals(stackInSlot.func_77973_b())) {
                armor = stackInSlot;
                continue;
            }
            if (Utils.isDye(stackInSlot)) {
                list.add(stackInSlot);
                continue;
            }
            return false;
        }
        if (!(earmuffs.func_190926_b() || armor.func_190926_b() && list.isEmpty())) {
            return true;
        }
        return !armor.func_190926_b() && ItemNBTHelper.hasKey(armor, "IE:Earmuffs") && earmuffs.func_190926_b() && list.isEmpty();
    }

    @Nonnull
    public ItemStack assemble(CraftingInventory inv) {
        ItemStack earmuffs = ItemStack.field_190927_a;
        ItemStack armor = ItemStack.field_190927_a;
        int[] colourArray = new int[3];
        int j = 0;
        int totalColourSets = 0;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stackInSlot = inv.func_70301_a(i);
            if (stackInSlot.func_190926_b()) continue;
            if (earmuffs.func_190926_b() && IEItems.Misc.earmuffs.equals(stackInSlot.func_77973_b())) {
                earmuffs = stackInSlot;
                int colour = ((IEItemInterfaces.IColouredItem)earmuffs.func_77973_b()).getColourForIEItem(earmuffs, 0);
                float r = (float)(colour >> 16 & 0xFF) / 255.0f;
                float g = (float)(colour >> 8 & 0xFF) / 255.0f;
                float b = (float)(colour & 0xFF) / 255.0f;
                j = (int)((float)j + Math.max(r, Math.max(g, b)) * 255.0f);
                colourArray[0] = (int)((float)colourArray[0] + r * 255.0f);
                colourArray[1] = (int)((float)colourArray[1] + g * 255.0f);
                colourArray[2] = (int)((float)colourArray[2] + b * 255.0f);
                ++totalColourSets;
                continue;
            }
            if (Utils.isDye(stackInSlot)) {
                float[] afloat = Utils.getDye(stackInSlot).func_193349_f();
                int r = (int)(afloat[0] * 255.0f);
                int g = (int)(afloat[1] * 255.0f);
                int b = (int)(afloat[2] * 255.0f);
                j += Math.max(r, Math.max(g, b));
                colourArray[0] = colourArray[0] + r;
                colourArray[1] = colourArray[1] + g;
                colourArray[2] = colourArray[2] + b;
                ++totalColourSets;
                continue;
            }
            if (!armor.func_190926_b() || !(stackInSlot.func_77973_b() instanceof ArmorItem) || ((ArmorItem)stackInSlot.func_77973_b()).func_185083_B_() != EquipmentSlotType.HEAD || IEItems.Misc.earmuffs.equals(stackInSlot.func_77973_b())) continue;
            armor = stackInSlot;
        }
        if (!earmuffs.func_190926_b()) {
            ItemStack output;
            if (totalColourSets > 1) {
                int r = colourArray[0] / totalColourSets;
                int g = colourArray[1] / totalColourSets;
                int b = colourArray[2] / totalColourSets;
                float colourMod = (float)j / (float)totalColourSets;
                float highestColour = Math.max(r, Math.max(g, b));
                r = (int)((float)r * colourMod / highestColour);
                g = (int)((float)g * colourMod / highestColour);
                b = (int)((float)b * colourMod / highestColour);
                int newColour = (r << 8) + g;
                newColour = (newColour << 8) + b;
                ItemNBTHelper.putInt(earmuffs, "IE:EarmuffColour", newColour);
            }
            if (!armor.func_190926_b()) {
                output = armor.func_77946_l();
                ItemNBTHelper.setItemStack(output, "IE:Earmuffs", earmuffs.func_77946_l());
            } else {
                output = earmuffs.func_77946_l();
            }
            return output;
        }
        if (!armor.func_190926_b() && ItemNBTHelper.hasKey(armor, "IE:Earmuffs")) {
            ItemStack output = armor.func_77946_l();
            ItemNBTHelper.remove(output, "IE:Earmuffs");
            return output;
        }
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int width, int height) {
        return width >= 2 && height >= 2;
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return new ItemStack((IItemProvider)IEItems.Misc.earmuffs, 1);
    }

    @Nonnull
    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        NonNullList remaining = super.func_179532_b((IInventory)inv);
        for (int i = 0; i < remaining.size(); ++i) {
            ItemStack stackInSlot = inv.func_70301_a(i);
            if (stackInSlot.func_190926_b() || !ItemNBTHelper.hasKey(stackInSlot, "IE:Earmuffs")) continue;
            remaining.set(i, (Object)ItemNBTHelper.getItemStack(stackInSlot, "IE:Earmuffs"));
        }
        return remaining;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)RecipeSerializers.EARMUFF_SERIALIZER.get();
    }

    public NonNullList<Ingredient> func_192400_c() {
        return NonNullList.func_191197_a((int)1, (Object)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{IEItems.Misc.earmuffs}));
    }
}

