/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.MixerRecipe;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.api.utils.DirectionalBlockPos;
import blusunrize.immersiveengineering.api.utils.shapes.CachedShapesWithTransform;
import blusunrize.immersiveengineering.common.IETileTypes;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.generic.PoweredMultiblockTileEntity;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IEMultiblocks;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import blusunrize.immersiveengineering.common.util.inventory.MultiFluidTank;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;

public class MixerTileEntity
extends PoweredMultiblockTileEntity<MixerTileEntity, MixerRecipe>
implements IEBlockInterfaces.IInteractionObjectIE,
IEBlockInterfaces.IBlockBounds {
    public MultiFluidTank tank = new MultiFluidTank(8000);
    public NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)8, (Object)ItemStack.field_190927_a);
    public float animation_agitator = 0.0f;
    public boolean outputAll;
    private static final CachedShapesWithTransform<BlockPos, Pair<Direction, Boolean>> SHAPES = CachedShapesWithTransform.createForMultiblock(MixerTileEntity::getShape);
    private CapabilityReference<IItemHandler> outputCap = CapabilityReference.forTileEntityAt(this, this::getOutputPos, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
    private LazyOptional<IItemHandler> insertionHandler = this.registerConstantCap(new IEInventoryHandler(8, (IIEInventory)this, 0, new boolean[]{true, true, true, true, true, true, true, true}, new boolean[8]));

    public MixerTileEntity() {
        super(IEMultiblocks.MIXER, 16000, true, (TileEntityType)IETileTypes.MIXER.get());
    }

    @Override
    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.tank.readFromNBT(nbt.func_74775_l("tank"));
        if (!descPacket) {
            this.inventory = Utils.readInventory(nbt.func_150295_c("inventory", 10), 8);
        }
        this.outputAll = nbt.func_74767_n("outputAll");
    }

    @Override
    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        CompoundNBT tankTag = this.tank.writeToNBT(new CompoundNBT());
        nbt.func_218657_a("tank", (INBT)tankTag);
        if (!descPacket) {
            nbt.func_218657_a("inventory", (INBT)Utils.writeInventory(this.inventory));
        }
        nbt.func_74757_a("outputAll", this.outputAll);
    }

    @Override
    public void receiveMessageFromClient(CompoundNBT message) {
        super.receiveMessageFromClient(message);
        if (message.func_150297_b("outputAll", 1)) {
            this.outputAll = message.func_74767_n("outputAll");
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.isDummy() || this.isRSDisabled()) {
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            if (this.shouldRenderAsActive()) {
                if (Utils.RAND.nextInt(8) == 0 && !this.tank.fluids.isEmpty()) {
                    FluidStack fs = this.tank.fluids.get(0);
                    float amount = (float)this.tank.getFluidAmount() / (float)this.tank.getCapacity() * 1.125f;
                    Vector3d partPos = new Vector3d((double)((float)this.func_174877_v().func_177958_n() + 0.5f + (float)this.getFacing().func_82601_c() * 0.5f + (float)(this.getIsMirrored() ? this.getFacing().func_176735_f() : this.getFacing().func_176746_e()).func_82601_c() * 0.5f), (double)((float)this.func_174877_v().func_177956_o() - 0.0625f + amount), (double)((float)this.func_174877_v().func_177952_p() + 0.5f + (float)this.getFacing().func_82599_e() * 0.5f + (float)(this.getIsMirrored() ? this.getFacing().func_176735_f() : this.getFacing().func_176746_e()).func_82599_e() * 0.5f));
                    float r = Utils.RAND.nextFloat() * 0.8125f;
                    float angleRad = (float)Math.toRadians(this.animation_agitator);
                    partPos = partPos.func_72441_c((double)r * Math.cos(angleRad), 0.0, (double)r * Math.sin(angleRad));
                    if (Utils.RAND.nextBoolean()) {
                        ImmersiveEngineering.proxy.spawnBubbleFX(this.field_145850_b, fs, partPos.field_72450_a, partPos.field_72448_b, partPos.field_72449_c, 0.0, 0.0, 0.0);
                    } else {
                        ImmersiveEngineering.proxy.spawnFluidSplashFX(this.field_145850_b, fs, partPos.field_72450_a, partPos.field_72448_b, partPos.field_72449_c, 0.0, 0.0, 0.0);
                    }
                }
                this.animation_agitator = (this.animation_agitator + 9.0f) % 360.0f;
            }
        } else {
            int fluidTypes;
            int tankAmount;
            boolean update = false;
            boolean foundRecipe = false;
            if (this.energyStorage.getEnergyStored() > 0 && this.processQueue.size() < this.getProcessQueueMaxLength() && (tankAmount = this.tank.getFluidAmount()) > 0) {
                HashSet<Integer> usedInvSlots = new HashSet<Integer>();
                for (PoweredMultiblockTileEntity.MultiblockProcess process : this.processQueue) {
                    if (!(process instanceof PoweredMultiblockTileEntity.MultiblockProcessInMachine)) continue;
                    for (int i : ((PoweredMultiblockTileEntity.MultiblockProcessInMachine)process).getInputSlots()) {
                        usedInvSlots.add(i);
                    }
                }
                NonNullList components = NonNullList.func_191197_a((int)this.inventory.size(), (Object)ItemStack.field_190927_a);
                for (int i = 0; i < components.size(); ++i) {
                    if (usedInvSlots.contains(i)) continue;
                    components.set(i, (Object)((ItemStack)this.inventory.get(i)));
                }
                for (FluidStack fs : this.tank.fluids) {
                    MixerRecipe recipe = MixerRecipe.findRecipe(fs, (NonNullList<ItemStack>)components);
                    if (recipe == null) continue;
                    foundRecipe = true;
                    PoweredMultiblockTileEntity.MultiblockProcessInMachine process = new MultiblockProcessMixer(recipe, recipe.getUsedSlots(fs, (NonNullList<ItemStack>)components)).setInputTanks(0);
                    if (!this.addProcessToQueue(process, true)) continue;
                    this.addProcessToQueue(process, false);
                    update = true;
                }
            }
            if ((fluidTypes = this.tank.getFluidTypes()) > 0 && (fluidTypes > 1 || !foundRecipe || this.outputAll)) {
                BlockPos outputPos = this.func_174877_v().func_177977_b().func_177967_a(this.getFacing().func_176734_d(), 2);
                update |= FluidUtil.getFluidHandler((World)this.field_145850_b, (BlockPos)outputPos, (Direction)this.getFacing()).map(output -> {
                    boolean ret;
                    block3: {
                        block2: {
                            ret = false;
                            if (this.outputAll) break block2;
                            FluidStack inTank = this.tank.getFluid();
                            FluidStack out = Utils.copyFluidStackWithAmount(inTank, Math.min(inTank.getAmount(), 80), false);
                            int accepted = output.fill(out, IFluidHandler.FluidAction.SIMULATE);
                            if (accepted <= 0) break block3;
                            int drained = output.fill(Utils.copyFluidStackWithAmount(out, Math.min(out.getAmount(), accepted), false), IFluidHandler.FluidAction.EXECUTE);
                            this.tank.drain(drained, IFluidHandler.FluidAction.EXECUTE);
                            ret = true;
                            break block3;
                        }
                        int totalOut = 0;
                        Iterator<FluidStack> it = this.tank.fluids.iterator();
                        while (it.hasNext()) {
                            FluidStack fs = it.next();
                            if (fs == null) continue;
                            FluidStack out = Utils.copyFluidStackWithAmount(fs, Math.min(fs.getAmount(), 80 - totalOut), false);
                            int accepted = output.fill(out, IFluidHandler.FluidAction.SIMULATE);
                            if (accepted > 0) {
                                int drained = output.fill(Utils.copyFluidStackWithAmount(out, Math.min(out.getAmount(), accepted), false), IFluidHandler.FluidAction.EXECUTE);
                                MultiFluidTank.drain(drained, fs, it, IFluidHandler.FluidAction.EXECUTE);
                                totalOut += drained;
                                ret = true;
                            }
                            if (totalOut < 80) continue;
                            break;
                        }
                    }
                    return ret;
                }).orElse(false).booleanValue();
            }
            if (update) {
                this.func_70296_d();
                this.markContainingBlockForUpdate(null);
            }
        }
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable ISelectionContext ctx) {
        return this.getShape(SHAPES);
    }

    private static List<AxisAlignedBB> getShape(BlockPos posInMultiblock) {
        if (new BlockPos(2, 0, 2).equals((Object)posInMultiblock)) {
            return ImmutableList.of((Object)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0), (Object)new AxisAlignedBB(0.125, 0.5, 0.625, 0.25, 1.0, 0.875), (Object)new AxisAlignedBB(0.75, 0.5, 0.625, 0.875, 1.0, 0.875));
        }
        if (posInMultiblock.func_177958_n() > 0 && posInMultiblock.func_177956_o() == 0 && posInMultiblock.func_177952_p() < 2) {
            List<AxisAlignedBB> list = Utils.flipBoxes(posInMultiblock.func_177952_p() == 0, posInMultiblock.func_177958_n() == 2, new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0), new AxisAlignedBB(0.0625, 0.5, 0.6875, 0.3125, 1.0, 0.9375));
            if (new BlockPos(1, 0, 1).equals((Object)posInMultiblock)) {
                list.add(new AxisAlignedBB(0.0, 0.5, 0.375, 1.125, 0.75, 0.625));
                list.add(new AxisAlignedBB(0.875, 0.5, -0.125, 1.125, 0.75, 0.375));
                list.add(new AxisAlignedBB(0.875, 0.75, -0.125, 1.125, 1.0, 0.125));
            }
            return list;
        }
        if (posInMultiblock.func_177958_n() > 0 && posInMultiblock.func_177956_o() == 1 && posInMultiblock.func_177952_p() < 2) {
            return Utils.flipBoxes(posInMultiblock.func_177952_p() == 0, posInMultiblock.func_177958_n() == 2, new AxisAlignedBB(0.1875, -0.25, 0.0, 1.0, 0.0, 0.8125), new AxisAlignedBB(0.0625, 0.0, 0.0, 0.1875, 1.0, 0.9375), new AxisAlignedBB(0.1875, 0.0, 0.8125, 1.0, 1.0, 0.9375));
        }
        if (new BlockPos(0, 2, 1).equals((Object)posInMultiblock)) {
            return ImmutableList.of((Object)new AxisAlignedBB(0.1875, 0.0, 0.1875, 1.0, 0.625, 0.6875));
        }
        if (new BlockPos(1, 2, 1).equals((Object)posInMultiblock)) {
            return ImmutableList.of((Object)new AxisAlignedBB(0.5625, 0.1875, -0.4375, 1.4375, 1.0, 0.4375), (Object)new AxisAlignedBB(0.0, 0.0, 0.0, 0.5625, 0.875, 0.5));
        }
        if (posInMultiblock.func_177956_o() == 0 && !ImmutableSet.of((Object)new BlockPos(0, 0, 2), (Object)new BlockPos(0, 0, 1), (Object)new BlockPos(1, 0, 2)).contains((Object)posInMultiblock)) {
            return ImmutableList.of((Object)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0));
        }
        if (new BlockPos(2, 1, 2).equals((Object)posInMultiblock)) {
            return ImmutableList.of((Object)new AxisAlignedBB(0.0, 0.0, 0.5, 1.0, 1.0, 1.0));
        }
        return ImmutableList.of((Object)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0));
    }

    @Override
    public Set<BlockPos> getEnergyPos() {
        return ImmutableSet.of((Object)new BlockPos(0, 1, 2));
    }

    @Override
    public Set<BlockPos> getRedstonePos() {
        return ImmutableSet.of((Object)new BlockPos(2, 1, 2));
    }

    @Override
    public boolean isInWorldProcessingMachine() {
        return false;
    }

    @Override
    public boolean additionalCanProcessCheck(PoweredMultiblockTileEntity.MultiblockProcess<MixerRecipe> process) {
        return true;
    }

    private DirectionalBlockPos getOutputPos() {
        return new DirectionalBlockPos(this.field_174879_c.func_177967_a(this.getFacing(), 2), this.getFacing());
    }

    @Override
    public void doProcessOutput(ItemStack output) {
        if (!(output = Utils.insertStackIntoInventory(this.outputCap, output, false)).func_190926_b()) {
            Utils.dropStackAtPos(this.field_145850_b, this.getOutputPos(), output);
        }
    }

    @Override
    public void doProcessFluidOutput(FluidStack output) {
    }

    @Override
    public void onProcessFinish(PoweredMultiblockTileEntity.MultiblockProcess<MixerRecipe> process) {
    }

    @Override
    public int getMaxProcessPerTick() {
        return 8;
    }

    @Override
    public int getProcessQueueMaxLength() {
        return 8;
    }

    @Override
    public float getMinProcessDistance(PoweredMultiblockTileEntity.MultiblockProcess<MixerRecipe> process) {
        return 0.0f;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return true;
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    @Override
    public int[] getOutputSlots() {
        return new int[0];
    }

    @Override
    public int[] getOutputTanks() {
        return new int[]{0};
    }

    @Override
    @Nonnull
    public IFluidTank[] getInternalTanks() {
        return new IFluidTank[]{this.tank};
    }

    @Override
    protected IFluidTank[] getAccessibleFluidTanks(Direction side) {
        MixerTileEntity master = (MixerTileEntity)this.master();
        if (master != null && (new BlockPos(1, 0, 2).equals((Object)this.posInMultiblock) && (side == null || side == this.getFacing().func_176734_d()) || new BlockPos(0, 0, 1).equals((Object)this.posInMultiblock) && (side == null || side == (this.getIsMirrored() ? this.getFacing().func_176746_e() : this.getFacing().func_176735_f())))) {
            return master.getInternalTanks();
        }
        return new FluidTank[0];
    }

    @Override
    protected boolean canFillTankFrom(int iTank, Direction side, FluidStack resources) {
        return side == null || side == (this.getIsMirrored() ? this.getFacing().func_176746_e() : this.getFacing().func_176735_f());
    }

    @Override
    protected boolean canDrainTankFrom(int iTank, Direction side) {
        return side == null || side == this.getFacing().func_176734_d();
    }

    @Override
    public void doGraphicalUpdates() {
        this.func_70296_d();
        this.markContainingBlockForUpdate(null);
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        MixerTileEntity master;
        if ((facing == null || new BlockPos(1, 1, 0).equals((Object)this.posInMultiblock)) && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && (master = (MixerTileEntity)this.master()) != null) {
            return master.insertionHandler.cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public MixerRecipe findRecipeForInsertion(ItemStack inserting) {
        return null;
    }

    @Override
    protected MixerRecipe getRecipeForId(ResourceLocation id) {
        return MixerRecipe.recipeList.get(id);
    }

    @Override
    protected PoweredMultiblockTileEntity.MultiblockProcess<MixerRecipe> loadProcessFromNBT(CompoundNBT tag) {
        String id = tag.func_74779_i("recipe");
        MixerRecipe recipe = this.getRecipeForId(new ResourceLocation(id));
        if (recipe != null) {
            return new MultiblockProcessMixer(recipe, tag.func_74759_k("process_inputSlots")).setInputTanks(tag.func_74759_k("process_inputTanks"));
        }
        return null;
    }

    @Override
    public boolean canUseGui(PlayerEntity player) {
        return this.formed;
    }

    @Override
    public IEBlockInterfaces.IInteractionObjectIE getGuiMaster() {
        return (IEBlockInterfaces.IInteractionObjectIE)((Object)this.master());
    }

    public static class MultiblockProcessMixer
    extends PoweredMultiblockTileEntity.MultiblockProcessInMachine<MixerRecipe> {
        public MultiblockProcessMixer(MixerRecipe recipe, int ... inputSlots) {
            super(recipe, inputSlots);
        }

        @Override
        protected List<FluidStack> getRecipeFluidOutputs(PoweredMultiblockTileEntity<?, MixerRecipe> multiblock) {
            return Collections.emptyList();
        }

        @Override
        protected List<FluidTagInput> getRecipeFluidInputs(PoweredMultiblockTileEntity<?, MixerRecipe> multiblock) {
            return Collections.emptyList();
        }

        @Override
        public boolean canProcess(PoweredMultiblockTileEntity<?, MixerRecipe> multiblock) {
            if (!(multiblock instanceof MixerTileEntity)) {
                return false;
            }
            MixerTileEntity mixer = (MixerTileEntity)multiblock;
            return mixer.energyStorage.extractEnergy(this.energyPerTick, true) == this.energyPerTick && !mixer.tank.drain(((MixerRecipe)this.recipe).fluidInput.withAmount(1), IFluidHandler.FluidAction.SIMULATE).isEmpty();
        }

        @Override
        public void doProcessTick(PoweredMultiblockTileEntity<?, MixerRecipe> multiblock) {
            int timerStep = Math.max(this.maxTicks / ((MixerRecipe)this.recipe).fluidAmount, 1);
            if (timerStep != 0 && this.processTick % timerStep == 0) {
                double distBetweenExtra;
                int amount = ((MixerRecipe)this.recipe).fluidAmount / this.maxTicks;
                int leftover = ((MixerRecipe)this.recipe).fluidAmount % this.maxTicks;
                if (leftover > 0 && Math.floor((double)this.processTick / (distBetweenExtra = (double)this.maxTicks / (double)leftover)) != Math.floor((double)(this.processTick - 1) / distBetweenExtra)) {
                    ++amount;
                }
                MixerTileEntity mixer = (MixerTileEntity)multiblock;
                FluidStack drained = mixer.tank.drain(((MixerRecipe)this.recipe).fluidInput.withAmount(amount), IFluidHandler.FluidAction.EXECUTE);
                if (!drained.isEmpty()) {
                    NonNullList components = NonNullList.func_191197_a((int)this.inputSlots.length, (Object)ItemStack.field_190927_a);
                    for (int i = 0; i < components.size(); ++i) {
                        components.set(i, (Object)((ItemStack)multiblock.getInventory().get(this.inputSlots[i])));
                    }
                    FluidStack output = ((MixerRecipe)this.recipe).getFluidOutput(drained, (NonNullList<ItemStack>)components);
                    FluidStack fs = Utils.copyFluidStackWithAmount(output, drained.getAmount(), false);
                    ((MixerTileEntity)multiblock).tank.fill(fs, IFluidHandler.FluidAction.EXECUTE);
                }
            }
            super.doProcessTick(multiblock);
        }
    }
}

