/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.generic;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.utils.client.CombinedModelData;
import blusunrize.immersiveengineering.api.utils.client.SinglePropertyModelData;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.ConnectorTileHelper;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.LocalWireNetwork;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.common.blocks.IEBaseTileEntity;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.client.model.data.IModelData;

public abstract class ImmersiveConnectableTileEntity
extends IEBaseTileEntity
implements IImmersiveConnectable {
    protected GlobalWireNetwork globalNet;
    private final Int2ObjectMap<LocalWireNetwork> cachedLocalNets = new Int2ObjectArrayMap();

    public ImmersiveConnectableTileEntity(TileEntityType<? extends ImmersiveConnectableTileEntity> type) {
        super(type);
    }

    @Override
    public boolean canConnect() {
        return true;
    }

    @Override
    public BlockPos getConnectionMaster(WireType cableType, TargetingInfo target) {
        return this.func_174877_v();
    }

    @Override
    public void connectCable(WireType cableType, ConnectionPoint target, IImmersiveConnectable other, ConnectionPoint otherTarget) {
    }

    @Override
    public void removeCable(Connection connection, ConnectionPoint attachedPoint) {
        this.func_70296_d();
    }

    @Override
    public void func_226984_a_(@Nonnull World worldIn, @Nonnull BlockPos pos) {
        super.func_226984_a_(worldIn, pos);
        this.globalNet = GlobalWireNetwork.getNetwork(worldIn);
    }

    @Override
    @Nullable
    public ConnectionPoint getTargetedPoint(TargetingInfo info, Vector3i offset) {
        return new ConnectionPoint(this.field_174879_c, 0);
    }

    @Override
    public void readCustomNBT(@Nonnull CompoundNBT nbt, boolean descPacket) {
    }

    @Override
    public void writeCustomNBT(@Nonnull CompoundNBT nbt, boolean descPacket) {
    }

    @Override
    @Nonnull
    public IModelData getModelData() {
        return CombinedModelData.combine(new SinglePropertyModelData<IEProperties.ConnectionModelData>(ConnectorTileHelper.genConnBlockState(this.field_145850_b, this), IEProperties.Model.CONNECTIONS), super.getModelData());
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        ConnectorTileHelper.onChunkUnload(this.globalNet, this);
    }

    public void onLoad() {
        super.onLoad();
        ConnectorTileHelper.onChunkLoad(this, this.field_145850_b);
    }

    public void func_145843_s() {
        super.func_145843_s();
        ConnectorTileHelper.remove(this.field_145850_b, this);
    }

    @Override
    public Collection<ConnectionPoint> getConnectionPoints() {
        return ImmutableList.of((Object)new ConnectionPoint(this.field_174879_c, 0));
    }

    protected LocalWireNetwork getLocalNet(int cpIndex) {
        return ConnectorTileHelper.getLocalNetWithCache(this.globalNet, this.func_174877_v(), cpIndex, this.cachedLocalNets);
    }

    @Override
    public BlockPos getPosition() {
        return this.field_174879_c;
    }
}

