/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.utils;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.config.IEClientConfig;
import blusunrize.immersiveengineering.common.util.DirectionUtils;
import blusunrize.immersiveengineering.mixin.accessors.client.PlayerControllerAccess;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mojang.blaze3d.vertex.MatrixApplyingVertexBuilder;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.AbstractSignBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ChestBlock;
import net.minecraft.block.EnderChestBlock;
import net.minecraft.block.SkullBlock;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerController;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;

public class RenderUtils {
    private static final float[][] quadCoords = new float[4][3];
    private static final int[][] neighbourBrightness = new int[2][6];
    private static final float[][] normalizationFactors = new float[2][8];

    public static void renderModelTESRFancy(List<BakedQuad> quads, IVertexBuilder renderer, World world, BlockPos pos, boolean useCached, int color, int light) {
        if (((Boolean)IEClientConfig.disableFancyTESR.get()).booleanValue()) {
            RenderUtils.renderModelTESRFast(quads, renderer, new MatrixStack(), world.func_226659_b_(pos, 0), color);
        } else {
            if (!useCached) {
                for (Direction f : DirectionUtils.VALUES) {
                    int val = WorldRenderer.func_228421_a_((IBlockDisplayReader)world, (BlockPos)pos.func_177972_a(f));
                    RenderUtils.neighbourBrightness[0][f.func_176745_a()] = val >> 16 & 0xFF;
                    RenderUtils.neighbourBrightness[1][f.func_176745_a()] = val & 0xFF;
                }
                for (int type = 0; type < 2; ++type) {
                    for (int i = 0; i < 8; ++i) {
                        float sSquared = 0.0f;
                        sSquared = (i & 1) != 0 ? (sSquared += RenderUtils.scaledSquared(neighbourBrightness[type][5], 255.0f)) : (sSquared += RenderUtils.scaledSquared(neighbourBrightness[type][4], 255.0f));
                        sSquared = (i & 2) != 0 ? (sSquared += RenderUtils.scaledSquared(neighbourBrightness[type][1], 255.0f)) : (sSquared += RenderUtils.scaledSquared(neighbourBrightness[type][0], 255.0f));
                        sSquared = (i & 4) != 0 ? (sSquared += RenderUtils.scaledSquared(neighbourBrightness[type][3], 255.0f)) : (sSquared += RenderUtils.scaledSquared(neighbourBrightness[type][2], 255.0f));
                        RenderUtils.normalizationFactors[type][i] = (float)Math.sqrt(sSquared);
                    }
                }
            }
            int[] rgba = new int[]{255, 255, 255, 255};
            if (color >= 0) {
                rgba[0] = color >> 16 & 0xFF;
                rgba[1] = color >> 8 & 0xFF;
                rgba[2] = color & 0xFF;
            }
            for (BakedQuad quad : quads) {
                int[] vData = quad.func_178209_a();
                VertexFormat format = DefaultVertexFormats.field_176600_a;
                int size = format.func_181719_f();
                int uvOffset = ClientUtils.findTextureOffset(format);
                int posOffset = ClientUtils.findPositionOffset(format);
                for (int i = 0; i < 4; ++i) {
                    RenderUtils.quadCoords[i][0] = Float.intBitsToFloat(vData[size * i + posOffset]);
                    RenderUtils.quadCoords[i][1] = Float.intBitsToFloat(vData[size * i + posOffset + 1]);
                    RenderUtils.quadCoords[i][2] = Float.intBitsToFloat(vData[size * i + posOffset + 2]);
                }
                Vector3d side1 = new Vector3d((double)(quadCoords[1][0] - quadCoords[3][0]), (double)(quadCoords[1][1] - quadCoords[3][1]), (double)(quadCoords[1][2] - quadCoords[3][2]));
                Vector3d side2 = new Vector3d((double)(quadCoords[2][0] - quadCoords[0][0]), (double)(quadCoords[2][1] - quadCoords[0][1]), (double)(quadCoords[2][2] - quadCoords[0][2]));
                Vector3d normal = side1.func_72431_c(side2);
                normal = normal.func_72432_b();
                int l1 = RenderUtils.getLightValue(neighbourBrightness[1], normalizationFactors[1], light & 0xFF, normal);
                int l2 = RenderUtils.getLightValue(neighbourBrightness[0], normalizationFactors[0], light >> 16 & 0xFF, normal);
                for (int i = 0; i < 4; ++i) {
                    renderer.func_225582_a_((double)quadCoords[i][0], (double)quadCoords[i][1], (double)quadCoords[i][2]).func_225586_a_(rgba[0], rgba[1], rgba[2], rgba[3]).func_225583_a_(Float.intBitsToFloat(vData[size * i + uvOffset]), Float.intBitsToFloat(vData[size * i + uvOffset + 1])).func_225587_b_(l1, l2).func_225584_a_((float)normal.field_72450_a, (float)normal.field_72448_b, (float)normal.field_72449_c).func_181675_d();
                }
            }
        }
    }

    private static int getLightValue(int[] neighbourBrightness, float[] normalizationFactors, int localBrightness, Vector3d normal) {
        double sideBrightness;
        byte type = 0;
        if (normal.field_72450_a > 0.0) {
            sideBrightness = normal.field_72450_a * (double)neighbourBrightness[5];
            type = (byte)(type | 1);
        } else {
            sideBrightness = -normal.field_72450_a * (double)neighbourBrightness[4];
        }
        if (normal.field_72448_b > 0.0) {
            sideBrightness += normal.field_72448_b * (double)neighbourBrightness[1];
            type = (byte)(type | 2);
        } else {
            sideBrightness += -normal.field_72448_b * (double)neighbourBrightness[0];
        }
        if (normal.field_72449_c > 0.0) {
            sideBrightness += normal.field_72449_c * (double)neighbourBrightness[3];
            type = (byte)(type | 4);
        } else {
            sideBrightness += -normal.field_72449_c * (double)neighbourBrightness[2];
        }
        return (int)(((double)localBrightness + sideBrightness / (double)normalizationFactors[type]) / 2.0);
    }

    private static float scaledSquared(int val, float scale) {
        return (float)val / scale * ((float)val / scale);
    }

    public static void renderModelTESRFast(List<BakedQuad> quads, IVertexBuilder renderer, MatrixStack transform, int light, int overlay) {
        RenderUtils.renderModelTESRFast(quads, renderer, transform, -1, light, overlay);
    }

    public static void renderModelTESRFast(List<BakedQuad> quads, IVertexBuilder renderer, MatrixStack transform, int color, int light, int overlay) {
        float red = 1.0f;
        float green = 1.0f;
        float blue = 1.0f;
        if (color >= 0) {
            red = (float)(color >> 16 & 0xFF) / 255.0f;
            green = (float)(color >> 8 & 0xFF) / 255.0f;
            blue = (float)(color & 0xFF) / 255.0f;
        }
        for (BakedQuad quad : quads) {
            renderer.func_227889_a_(transform.func_227866_c_(), quad, red, green, blue, light, overlay);
        }
    }

    public static void drawBlockDamageTexture(MatrixStack matrix, IRenderTypeBuffer buffers, World world, Collection<BlockPos> blocks) {
        PlayerController controller = Minecraft.func_71410_x().field_71442_b;
        int progress = (int)(((PlayerControllerAccess)controller).getDestroyProgress() * 10.0f) - 1;
        if (progress < 0 || progress >= ModelBakery.field_229320_k_.size()) {
            return;
        }
        BlockRendererDispatcher blockrendererdispatcher = Minecraft.func_71410_x().func_175602_ab();
        for (BlockPos blockpos : blocks) {
            BlockState iblockstate;
            boolean hasBreak;
            matrix.func_227860_a_();
            matrix.func_227861_a_((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p());
            IVertexBuilder worldRendererIn = buffers.getBuffer((RenderType)ModelBakery.field_229320_k_.get(progress));
            worldRendererIn = new MatrixApplyingVertexBuilder(worldRendererIn, matrix.func_227866_c_().func_227870_a_(), matrix.func_227866_c_().func_227872_b_());
            Block block = world.func_180495_p(blockpos).func_177230_c();
            boolean bl = hasBreak = block instanceof ChestBlock || block instanceof EnderChestBlock || block instanceof AbstractSignBlock || block instanceof SkullBlock;
            if (!hasBreak && (iblockstate = world.func_180495_p(blockpos)).func_185904_a() != Material.field_151579_a) {
                blockrendererdispatcher.func_228792_a_(iblockstate, blockpos, (IBlockDisplayReader)world, matrix, worldRendererIn);
            }
            matrix.func_227865_b_();
        }
    }

    public static void renderBox(IVertexBuilder wr, MatrixStack m, float x0, float y0, float z0, float x1, float y1, float z1) {
        Matrix4f transform = m.func_227866_c_().func_227870_a_();
        wr.func_227888_a_(transform, x0, y0, z1).func_181675_d();
        wr.func_227888_a_(transform, x1, y0, z1).func_181675_d();
        wr.func_227888_a_(transform, x1, y1, z1).func_181675_d();
        wr.func_227888_a_(transform, x0, y1, z1).func_181675_d();
        wr.func_227888_a_(transform, x0, y1, z0).func_181675_d();
        wr.func_227888_a_(transform, x1, y1, z0).func_181675_d();
        wr.func_227888_a_(transform, x1, y0, z0).func_181675_d();
        wr.func_227888_a_(transform, x0, y0, z0).func_181675_d();
        wr.func_227888_a_(transform, x0, y0, z0).func_181675_d();
        wr.func_227888_a_(transform, x1, y0, z0).func_181675_d();
        wr.func_227888_a_(transform, x1, y0, z1).func_181675_d();
        wr.func_227888_a_(transform, x0, y0, z1).func_181675_d();
        wr.func_227888_a_(transform, x0, y1, z1).func_181675_d();
        wr.func_227888_a_(transform, x1, y1, z1).func_181675_d();
        wr.func_227888_a_(transform, x1, y1, z0).func_181675_d();
        wr.func_227888_a_(transform, x0, y1, z0).func_181675_d();
        wr.func_227888_a_(transform, x0, y0, z0).func_181675_d();
        wr.func_227888_a_(transform, x0, y0, z1).func_181675_d();
        wr.func_227888_a_(transform, x0, y1, z1).func_181675_d();
        wr.func_227888_a_(transform, x0, y1, z0).func_181675_d();
        wr.func_227888_a_(transform, x1, y1, z0).func_181675_d();
        wr.func_227888_a_(transform, x1, y1, z1).func_181675_d();
        wr.func_227888_a_(transform, x1, y0, z1).func_181675_d();
        wr.func_227888_a_(transform, x1, y0, z0).func_181675_d();
    }

    public static void renderTexturedBox(IVertexBuilder wr, MatrixStack stack, float x0, float y0, float z0, float x1, float y1, float z1, TextureAtlasSprite tex, boolean yForV) {
        float minU = tex.func_94214_a((double)(x0 * 16.0f));
        float maxU = tex.func_94214_a((double)(x1 * 16.0f));
        float minV = tex.func_94207_b((double)((yForV ? y1 : z0) * 16.0f));
        float maxV = tex.func_94207_b((double)((yForV ? y0 : z1) * 16.0f));
        RenderUtils.renderTexturedBox(wr, stack, x0, y0, z0, x1, y1, z1, minU, minV, maxU, maxV);
    }

    public static void renderTexturedBox(IVertexBuilder wr, MatrixStack stack, float x0, float y0, float z0, float x1, float y1, float z1, float u0, float v0, float u1, float v1) {
        float normalX = 0.0f;
        float normalY = 0.0f;
        float normalZ = 1.0f;
        RenderUtils.putVertex(wr, stack, x0, y0, z1, u0, v0, normalX, normalY, normalZ);
        RenderUtils.putVertex(wr, stack, x1, y0, z1, u1, v0, normalX, normalY, normalZ);
        RenderUtils.putVertex(wr, stack, x1, y1, z1, u1, v1, normalX, normalY, normalZ);
        RenderUtils.putVertex(wr, stack, x0, y1, z1, u0, v1, normalX, normalY, normalZ);
        normalZ = -1.0f;
        RenderUtils.putVertex(wr, stack, x0, y1, z0, u0, v0, normalX, normalY, normalZ);
        RenderUtils.putVertex(wr, stack, x1, y1, z0, u1, v0, normalX, normalY, normalZ);
        RenderUtils.putVertex(wr, stack, x1, y0, z0, u1, v1, normalX, normalY, normalZ);
        RenderUtils.putVertex(wr, stack, x0, y0, z0, u0, v1, normalX, normalY, normalZ);
        normalZ = 0.0f;
        normalY = -1.0f;
        RenderUtils.putVertex(wr, stack, x0, y0, z0, u0, v0, normalX, normalY, normalZ);
        RenderUtils.putVertex(wr, stack, x1, y0, z0, u1, v0, normalX, normalY, normalZ);
        RenderUtils.putVertex(wr, stack, x1, y0, z1, u1, v1, normalX, normalY, normalZ);
        RenderUtils.putVertex(wr, stack, x0, y0, z1, u0, v1, normalX, normalY, normalZ);
        normalY = 1.0f;
        RenderUtils.putVertex(wr, stack, x0, y1, z1, u0, v0, normalX, normalY, normalZ);
        RenderUtils.putVertex(wr, stack, x1, y1, z1, u1, v0, normalX, normalY, normalZ);
        RenderUtils.putVertex(wr, stack, x1, y1, z0, u1, v1, normalX, normalY, normalZ);
        RenderUtils.putVertex(wr, stack, x0, y1, z0, u0, v1, normalX, normalY, normalZ);
        normalY = 0.0f;
        normalX = -1.0f;
        RenderUtils.putVertex(wr, stack, x0, y0, z0, u0, v0, normalX, normalY, normalZ);
        RenderUtils.putVertex(wr, stack, x0, y0, z1, u1, v0, normalX, normalY, normalZ);
        RenderUtils.putVertex(wr, stack, x0, y1, z1, u1, v1, normalX, normalY, normalZ);
        RenderUtils.putVertex(wr, stack, x0, y1, z0, u0, v1, normalX, normalY, normalZ);
        normalX = 1.0f;
        RenderUtils.putVertex(wr, stack, x1, y1, z0, u0, v0, normalX, normalY, normalZ);
        RenderUtils.putVertex(wr, stack, x1, y1, z1, u1, v0, normalX, normalY, normalZ);
        RenderUtils.putVertex(wr, stack, x1, y0, z1, u1, v1, normalX, normalY, normalZ);
        RenderUtils.putVertex(wr, stack, x1, y0, z0, u0, v1, normalX, normalY, normalZ);
    }

    private static void putVertex(IVertexBuilder b, MatrixStack mat, float x, float y, float z, float u, float v, float nX, float nY, float nZ) {
        b.func_227888_a_(mat.func_227866_c_().func_227870_a_(), x, y, z).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(u, v).func_225587_b_(0, 0).func_227887_a_(mat.func_227866_c_().func_227872_b_(), nX, nY, nZ).func_181675_d();
    }
}

