/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.gui.IEContainerScreen;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonIE;
import blusunrize.immersiveengineering.common.blocks.generic.PoweredMultiblockTileEntity;
import blusunrize.immersiveengineering.common.blocks.metal.ArcFurnaceTileEntity;
import blusunrize.immersiveengineering.common.gui.ArcFurnaceContainer;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.client.gui.GuiUtils;

public class ArcFurnaceScreen
extends IEContainerScreen<ArcFurnaceContainer> {
    private static final ResourceLocation TEXTURE = ArcFurnaceScreen.makeTextureLocation("arc_furnace");
    private ArcFurnaceTileEntity tile;
    private GuiButtonIE distributeButton;

    public ArcFurnaceScreen(ArcFurnaceContainer container, PlayerInventory inventoryPlayer, ITextComponent title) {
        super(container, inventoryPlayer, title);
        this.field_147000_g = 207;
        this.tile = (ArcFurnaceTileEntity)container.tile;
    }

    @Override
    public void func_230430_a_(MatrixStack transform, int mx, int my, float partial) {
        super.func_230430_a_(transform, mx, my, partial);
        ArrayList<Object> tooltip = new ArrayList<Object>();
        if (mx > this.field_147003_i + 157 && mx < this.field_147003_i + 164 && my > this.field_147009_r + 22 && my < this.field_147009_r + 68) {
            tooltip.add(new StringTextComponent(this.tile.getEnergyStored(null) + "/" + this.tile.getMaxEnergyStored(null) + " IF"));
        }
        if (this.distributeButton.func_230449_g_()) {
            tooltip.add(new TranslationTextComponent("gui.immersiveengineering.config.arcfurnace.distribute"));
        }
        if (!tooltip.isEmpty()) {
            GuiUtils.drawHoveringText((MatrixStack)transform, tooltip, (int)mx, (int)my, (int)this.field_230708_k_, (int)this.field_230709_l_, (int)-1, (FontRenderer)this.field_230712_o_);
        }
    }

    protected void func_230450_a_(MatrixStack transform, float f, int mx, int my) {
        ClientUtils.bindTexture(TEXTURE);
        this.func_238474_b_(transform, this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        for (PoweredMultiblockTileEntity.MultiblockProcess process : this.tile.processQueue) {
            if (!(process instanceof PoweredMultiblockTileEntity.MultiblockProcessInMachine)) continue;
            float mod = (float)process.processTick / (float)process.maxTicks;
            int slot = ((PoweredMultiblockTileEntity.MultiblockProcessInMachine)process).getInputSlots()[0];
            int h = (int)Math.max(1.0f, mod * 16.0f);
            this.func_238474_b_(transform, this.field_147003_i + 27 + slot % 3 * 21, this.field_147009_r + 34 + slot / 3 * 18 + (16 - h), 176, 16 - h, 2, h);
        }
        int stored = (int)(46.0f * ((float)this.tile.getEnergyStored(null) / (float)this.tile.getMaxEnergyStored(null)));
        this.func_238468_a_(transform, this.field_147003_i + 157, this.field_147009_r + 22 + (46 - stored), this.field_147003_i + 164, this.field_147009_r + 68, -4909824, -10482944);
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        final Minecraft mc = ClientUtils.mc();
        this.distributeButton = new GuiButtonIE(this.field_147003_i + 10, this.field_147009_r + 10, 16, 16, StringTextComponent.field_240750_d_, TEXTURE, 179, 0, btn -> {
            if (mc.field_71439_g != null && mc.field_71439_g.field_71071_by.func_70445_o().func_190926_b()) {
                this.autoSplitStacks();
            }
        }){

            public boolean func_230449_g_() {
                return super.func_230449_g_() && mc.field_71439_g != null && mc.field_71439_g.field_71071_by.func_70445_o().func_190926_b();
            }
        }.setHoverOffset(0, 16);
        this.func_230480_a_((Widget)this.distributeButton);
    }

    private void autoSplitStacks() {
        for (int j = 0; j < 12; ++j) {
            int emptySlot = -1;
            int largestSlot = -1;
            int largestCount = -1;
            for (int i = 0; i < 12; ++i) {
                if (((ArcFurnaceContainer)this.field_147002_h).func_75139_a(i).func_75216_d()) {
                    int count = ((ArcFurnaceContainer)this.field_147002_h).func_75139_a(i).func_75211_c().func_190916_E();
                    if (count <= 1 || count <= largestCount) continue;
                    largestSlot = i;
                    largestCount = count;
                    continue;
                }
                if (emptySlot >= 0) continue;
                emptySlot = i;
            }
            if (emptySlot < 0 || largestSlot < 0) break;
            this.func_184098_a(((ArcFurnaceContainer)this.field_147002_h).func_75139_a(largestSlot), largestSlot, 1, ClickType.PICKUP);
            this.func_184098_a(((ArcFurnaceContainer)this.field_147002_h).func_75139_a(emptySlot), emptySlot, 0, ClickType.PICKUP);
        }
    }
}

