/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.wires.utils;

import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;

public class WireLink {
    public final ConnectionPoint cp;
    public final RegistryKey<World> dimension;
    public final BlockPos offset;
    public final TargetingInfo target;

    public WireLink(ConnectionPoint cp, RegistryKey<World> dimension, BlockPos offset, TargetingInfo info) {
        this.cp = cp;
        this.dimension = dimension;
        this.offset = offset.func_185334_h();
        this.target = info;
    }

    public static WireLink create(ConnectionPoint cp, World world, BlockPos offset, TargetingInfo info) {
        return new WireLink(cp, (RegistryKey<World>)world.func_234923_W_(), offset, info);
    }

    public void writeToItem(ItemStack stack) {
        CompoundNBT nbt = stack.func_196082_o();
        nbt.func_74778_a("linkingDim", this.dimension.func_240901_a_().toString());
        nbt.func_218657_a("linkingPos", (INBT)this.cp.createTag());
        nbt.func_218657_a("linkingOffset", (INBT)NBTUtil.func_186859_a((BlockPos)this.offset));
        CompoundNBT targetNBT = new CompoundNBT();
        this.target.writeToNBT(targetNBT);
        nbt.func_218657_a("linkingTarget", (INBT)targetNBT);
    }

    public static WireLink readFromItem(ItemStack stack) {
        CompoundNBT nbt = stack.func_77942_o() ? stack.func_196082_o() : new CompoundNBT();
        ConnectionPoint cp = new ConnectionPoint(nbt.func_74775_l("linkingPos"));
        ResourceLocation dim = new ResourceLocation(nbt.func_74779_i("linkingDim"));
        BlockPos offset = NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("linkingOffset"));
        TargetingInfo info = TargetingInfo.readFromNBT(nbt.func_74775_l("linkingTarget"));
        return new WireLink(cp, (RegistryKey<World>)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)dim), offset, info);
    }
}

