/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.tool;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Locale;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class LogicCircuitHandler {

    public static interface ILogicCircuitHandler {
        public boolean getLogicCircuitRegister(LogicCircuitRegister var1);

        public void setLogicCircuitRegister(LogicCircuitRegister var1, boolean var2);
    }

    public static final class LogicCircuitInstruction {
        private final LogicCircuitOperator operator;
        private final LogicCircuitRegister output;
        private final LogicCircuitRegister[] inputs;
        private final TextComponent formattedString;

        public LogicCircuitInstruction(LogicCircuitOperator operator, LogicCircuitRegister output, LogicCircuitRegister[] inputs) {
            Preconditions.checkArgument((operator.getArgumentCount() == inputs.length ? 1 : 0) != 0, (Object)"Logic inputs must match the argument count of the operator");
            this.operator = operator;
            this.output = output;
            this.inputs = inputs;
            this.formattedString = this.output.getDescription();
            this.formattedString.func_240702_b_(" = ");
            this.formattedString.func_230529_a_((ITextComponent)this.operator.getDescription());
            for (int i = 0; i < inputs.length; ++i) {
                this.formattedString.func_240702_b_(i != 0 ? ", " : ": ");
                this.formattedString.func_230529_a_((ITextComponent)inputs[i].getDescription());
            }
        }

        public LogicCircuitOperator getOperator() {
            return this.operator;
        }

        public LogicCircuitRegister getOutput() {
            return this.output;
        }

        public LogicCircuitRegister[] getInputs() {
            return this.inputs;
        }

        public void apply(ILogicCircuitHandler handler) {
            boolean[] bInputs = new boolean[this.operator.getArgumentCount()];
            for (int i = 0; i < this.inputs.length; ++i) {
                bInputs[i] = handler.getLogicCircuitRegister(this.inputs[i]);
            }
            handler.setLogicCircuitRegister(this.output, this.operator.apply(bInputs));
        }

        public TextComponent getFormattedString() {
            return this.formattedString;
        }

        public CompoundNBT serialize() {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74778_a("operator", this.operator.name());
            nbt.func_74778_a("output", this.output.name());
            ListNBT inputList = new ListNBT();
            for (LogicCircuitRegister input : this.inputs) {
                inputList.add((Object)StringNBT.func_229705_a_((String)input.name()));
            }
            nbt.func_218657_a("inputs", (INBT)inputList);
            return nbt;
        }

        public static LogicCircuitInstruction deserialize(CompoundNBT nbt) {
            LogicCircuitOperator operator = LogicCircuitOperator.valueOf(nbt.func_74779_i("operator"));
            LogicCircuitRegister output = LogicCircuitRegister.valueOf(nbt.func_74779_i("output"));
            ListNBT inputList = nbt.func_150295_c("inputs", 8);
            LogicCircuitRegister[] inputs = new LogicCircuitRegister[inputList.size()];
            for (int i = 0; i < inputs.length; ++i) {
                inputs[i] = LogicCircuitRegister.valueOf(inputList.func_150307_f(i));
            }
            return new LogicCircuitInstruction(operator, output, inputs);
        }
    }

    public static enum LogicCircuitRegister {
        WHITE,
        ORANGE,
        MAGENTA,
        LIGHT_BLUE,
        YELLOW,
        LIME,
        PINK,
        GRAY,
        LIGHT_GRAY,
        CYAN,
        PURPLE,
        BLUE,
        BROWN,
        GREEN,
        RED,
        BLACK,
        R0,
        R1,
        R2,
        R3,
        R4,
        R5,
        R6,
        R7;


        public TextComponent getDescription() {
            if (this.ordinal() < 16) {
                return new TranslationTextComponent("color.minecraft." + DyeColor.func_196056_a((int)this.ordinal()).func_176762_d());
            }
            return new TranslationTextComponent("desc.immersiveengineering.info.register", new Object[]{this.ordinal() - 16});
        }
    }

    public static enum LogicCircuitOperator {
        SET(1, args -> args[0], 0),
        NOT(1, args -> !args[0], 1),
        OR(2, args -> args[0] | args[1], 3),
        AND(2, args -> args[0] & args[1], 2),
        XOR(2, args -> args[0] ^ args[1], 4),
        NOR(2, args -> !(args[0] | args[1]), 4),
        NAND(2, args -> !(args[0] & args[1]), 1),
        XNOR(2, args -> args[0] == args[1], 5);

        private final int argumentCount;
        private final Predicate<boolean[]> operator;
        private final int complexity;
        public static final int TOTAL_MAX_INPUTS;

        private LogicCircuitOperator(int argumentCount, Predicate<boolean[]> operator, int complexity) {
            this.argumentCount = argumentCount;
            this.operator = operator;
            this.complexity = complexity;
        }

        public int getArgumentCount() {
            return this.argumentCount;
        }

        public int getComplexity() {
            return this.complexity;
        }

        public boolean apply(boolean[] args) {
            return this.operator.test(args);
        }

        @Nullable
        public static LogicCircuitOperator getByString(String name) {
            if (name == null) {
                return null;
            }
            return LogicCircuitOperator.valueOf(name);
        }

        public TextComponent getDescription() {
            return new TranslationTextComponent("desc.immersiveengineering.info.operator." + this.name().toLowerCase(Locale.ENGLISH));
        }

        static {
            TOTAL_MAX_INPUTS = Arrays.stream(LogicCircuitOperator.values()).mapToInt(LogicCircuitOperator::getArgumentCount).max().orElse(1);
        }
    }
}

