/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.multiblocks;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

public class MultiblockHandler {
    private static final Direction[] DIRECTIONS = Direction.values();
    static ArrayList<IMultiblock> multiblocks = new ArrayList();
    static Map<ResourceLocation, IMultiblock> byUniqueName = new HashMap<ResourceLocation, IMultiblock>();

    public static void registerMultiblock(IMultiblock multiblock) {
        multiblocks.add(multiblock);
        byUniqueName.put(multiblock.getUniqueName(), multiblock);
    }

    public static ArrayList<IMultiblock> getMultiblocks() {
        return multiblocks;
    }

    @Nullable
    public static IMultiblock getByUniqueName(ResourceLocation name) {
        return byUniqueName.get(name);
    }

    public static MultiblockFormEvent postMultiblockFormationEvent(PlayerEntity player, IMultiblock multiblock, BlockPos clickedBlock, ItemStack hammer) {
        MultiblockFormEvent event = new MultiblockFormEvent(player, multiblock, clickedBlock, hammer);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event;
    }

    public static interface IMultiblock {
        public ResourceLocation getUniqueName();

        public boolean isBlockTrigger(BlockState var1, Direction var2, @Nullable World var3);

        public boolean createStructure(World var1, BlockPos var2, Direction var3, PlayerEntity var4);

        public List<Template.BlockInfo> getStructure(@Nullable World var1);

        @OnlyIn(value=Dist.CLIENT)
        public ItemStack[] getTotalMaterials();

        @OnlyIn(value=Dist.CLIENT)
        public boolean overwriteBlockRender(BlockState var1, int var2);

        public float getManualScale();

        @OnlyIn(value=Dist.CLIENT)
        public boolean canRenderFormedStructure();

        @OnlyIn(value=Dist.CLIENT)
        public void renderFormedStructure(MatrixStack var1, IRenderTypeBuffer var2);

        public Vector3i getSize(@Nullable World var1);

        public void disassemble(World var1, BlockPos var2, boolean var3, Direction var4);

        public BlockPos getTriggerOffset();
    }

    @Cancelable
    public static class MultiblockFormEvent
    extends PlayerEvent {
        private final IMultiblock multiblock;
        private final BlockPos clickedBlock;
        private final ItemStack hammer;

        public MultiblockFormEvent(PlayerEntity player, IMultiblock multiblock, BlockPos clickedBlock, ItemStack hammer) {
            super(player);
            this.multiblock = multiblock;
            this.clickedBlock = clickedBlock;
            this.hammer = hammer;
        }

        public IMultiblock getMultiblock() {
            return this.multiblock;
        }

        public BlockPos getClickedBlock() {
            return this.clickedBlock;
        }

        public ItemStack getHammer() {
            return this.hammer;
        }
    }
}

