/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.message;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.entity.EntityHydra;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessagePlayerHitMultipart {
    public int creatureID;
    public int extraData;

    public MessagePlayerHitMultipart(int creatureID) {
        this.creatureID = creatureID;
        this.extraData = 0;
    }

    public MessagePlayerHitMultipart(int creatureID, int extraData) {
        this.creatureID = creatureID;
        this.extraData = extraData;
    }

    public MessagePlayerHitMultipart() {
    }

    public static MessagePlayerHitMultipart read(PacketBuffer buf) {
        return new MessagePlayerHitMultipart(buf.readInt(), buf.readInt());
    }

    public static void write(MessagePlayerHitMultipart message, PacketBuffer buf) {
        buf.writeInt(message.creatureID);
        buf.writeInt(message.extraData);
    }

    public static class Handler {
        public static void handle(MessagePlayerHitMultipart message, Supplier<NetworkEvent.Context> context) {
            Entity entity;
            context.get().setPacketHandled(true);
            ServerPlayerEntity player = context.get().getSender();
            if (context.get().getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                player = IceAndFire.PROXY.getClientSidePlayer();
            }
            if (player != null && player.field_70170_p != null && (entity = player.field_70170_p.func_73045_a(message.creatureID)) != null && entity instanceof LivingEntity) {
                double dist = player.func_70032_d(entity);
                LivingEntity mob = (LivingEntity)entity;
                if (dist < 100.0) {
                    player.func_71059_n((Entity)mob);
                    if (mob instanceof EntityHydra) {
                        ((EntityHydra)mob).triggerHeadFlags(message.extraData);
                    }
                }
            }
        }
    }
}

