/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.loot;

import com.github.alexthe666.iceandfire.entity.DragonType;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import com.github.alexthe666.iceandfire.item.ItemDragonEgg;
import com.github.alexthe666.iceandfire.item.ItemDragonFlesh;
import com.github.alexthe666.iceandfire.item.ItemDragonScales;
import com.github.alexthe666.iceandfire.item.ItemDragonSkull;
import com.github.alexthe666.iceandfire.loot.IafLootRegistry;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootFunction;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.IItemProvider;

public class CustomizeToDragon
extends LootFunction {
    public CustomizeToDragon(ILootCondition[] conditionsIn) {
        super(conditionsIn);
    }

    protected ItemStack func_215859_a(ItemStack stack, LootContext context) {
        if (!stack.func_190926_b() && context.func_216031_c(LootParameters.field_216281_a) instanceof EntityDragonBase) {
            Random random = new Random();
            EntityDragonBase dragon = (EntityDragonBase)context.func_216031_c(LootParameters.field_216281_a);
            if (dragon == null) {
                return stack;
            }
            if (stack.func_77973_b() == IafItemRegistry.DRAGON_BONE) {
                stack.func_190920_e(1 + random.nextInt(1 + dragon.getAgeInDays() / 25));
                return stack;
            }
            if (stack.func_77973_b() instanceof ItemDragonScales) {
                stack.func_190920_e(dragon.getAgeInDays() / 25 + random.nextInt(1 + dragon.getAgeInDays() / 5));
                return new ItemStack((IItemProvider)dragon.getVariantScale(dragon.getVariant()), stack.func_190916_E());
            }
            if (stack.func_77973_b() instanceof ItemDragonEgg) {
                if (dragon.func_230282_cS_()) {
                    return new ItemStack((IItemProvider)dragon.getVariantEgg(dragon.getVariant()), stack.func_190916_E());
                }
                stack.func_190920_e(1 + random.nextInt(1 + dragon.getAgeInDays() / 5));
                return new ItemStack((IItemProvider)dragon.getVariantScale(dragon.getVariant()), stack.func_190916_E());
            }
            if (stack.func_77973_b() instanceof ItemDragonFlesh) {
                stack.func_190920_e(1 + random.nextInt(1 + dragon.getAgeInDays() / 25));
                return new ItemStack((IItemProvider)stack.func_77973_b(), stack.func_190916_E());
            }
            if (stack.func_77973_b() instanceof ItemDragonSkull) {
                ItemStack stack1 = new ItemStack((IItemProvider)(dragon.dragonType == DragonType.FIRE ? IafItemRegistry.DRAGON_SKULL_FIRE : IafItemRegistry.DRAGON_SKULL_ICE), stack.func_190916_E());
                stack1.func_77982_d(stack.func_77978_p());
                return stack1;
            }
            if (stack.func_77973_b() == IafItemRegistry.FIRE_DRAGON_BLOOD || stack.func_77973_b() == IafItemRegistry.ICE_DRAGON_BLOOD) {
                return new ItemStack((IItemProvider)(dragon.dragonType == DragonType.FIRE ? IafItemRegistry.FIRE_DRAGON_BLOOD : IafItemRegistry.ICE_DRAGON_BLOOD), stack.func_190916_E());
            }
            if (stack.func_77973_b() == IafItemRegistry.FIRE_DRAGON_HEART || stack.func_77973_b() == IafItemRegistry.ICE_DRAGON_HEART) {
                return new ItemStack((IItemProvider)(dragon.dragonType == DragonType.FIRE ? IafItemRegistry.FIRE_DRAGON_HEART : IafItemRegistry.ICE_DRAGON_HEART), stack.func_190916_E());
            }
        }
        return stack;
    }

    public LootFunctionType func_230425_b_() {
        return IafLootRegistry.CUSTOMIZE_TO_DRAGON;
    }

    public static class Serializer
    extends LootFunction.Serializer<CustomizeToDragon> {
        public void serialize(JsonObject object, CustomizeToDragon functionClazz, JsonSerializationContext serializationContext) {
        }

        public CustomizeToDragon deserialize(JsonObject object, JsonDeserializationContext deserializationContext, ILootCondition[] conditionsIn) {
            return new CustomizeToDragon(conditionsIn);
        }
    }
}

