/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.item;

import com.github.alexthe666.citadel.server.item.CustomArmorMaterial;
import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.enums.EnumTroll;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemTrollArmor
extends ArmorItem {
    public EnumTroll troll;

    public ItemTrollArmor(EnumTroll troll, CustomArmorMaterial material, EquipmentSlotType slot) {
        super((IArmorMaterial)material, slot, new Item.Properties().func_200916_a(IceAndFire.TAB_ITEMS));
        this.troll = troll;
        this.setRegistryName(troll.name().toLowerCase(Locale.ROOT) + "_troll_leather_" + this.getArmorPart(slot));
    }

    public IArmorMaterial func_200880_d() {
        return this.troll.material;
    }

    private String getArmorPart(EquipmentSlotType slot) {
        switch (slot) {
            case HEAD: {
                return "helmet";
            }
            case CHEST: {
                return "chestplate";
            }
            case LEGS: {
                return "leggings";
            }
            case FEET: {
                return "boots";
            }
        }
        return "";
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public <A extends BipedModel<?>> A getArmorModel(LivingEntity LivingEntity2, ItemStack itemStack, EquipmentSlotType armorSlot, A _default) {
        return (A)((BipedModel)IceAndFire.PROXY.getArmorModel(this.field_77881_a == EquipmentSlotType.LEGS ? 7 : 6));
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        return "iceandfire:textures/models/armor/armor_troll_" + this.troll.name().toLowerCase(Locale.ROOT) + (slot == EquipmentSlotType.LEGS ? "_legs.png" : ".png");
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("item.iceandfire.troll_leather_armor_" + this.getArmorPart(this.field_77881_a) + ".desc").func_240699_a_(TextFormatting.GREEN));
    }
}

