/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.item;

import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import com.github.alexthe666.iceandfire.world.DragonPosWorldData;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class ItemSummoningCrystal
extends Item {
    public ItemSummoningCrystal(String variant) {
        super(new Item.Properties().func_200916_a(IceAndFire.TAB_ITEMS).func_200917_a(1));
        this.setRegistryName("iceandfire", "summoning_crystal_" + variant);
    }

    public static boolean hasDragon(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemSummoningCrystal && stack.func_77978_p() != null) {
            for (String tagInfo : stack.func_77978_p().func_150296_c()) {
                if (!tagInfo.contains("Dragon")) continue;
                return true;
            }
        }
        return false;
    }

    public void func_77622_d(ItemStack itemStack, World world, PlayerEntity player) {
        itemStack.func_77982_d(new CompoundNBT());
    }

    public ItemStack onItemUseFinish(World worldIn, LivingEntity LivingEntity2) {
        return new ItemStack((IItemProvider)this);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        boolean flag = false;
        String desc = "entity.firedragon.name";
        if (stack.func_77973_b() == IafItemRegistry.SUMMONING_CRYSTAL_ICE) {
            desc = "entity.icedragon.name";
        }
        if (stack.func_77973_b() == IafItemRegistry.SUMMONING_CRYSTAL_LIGHTNING) {
            desc = "entity.lightningdragon.name";
        }
        if (stack.func_77978_p() != null) {
            for (String tagInfo : stack.func_77978_p().func_150296_c()) {
                if (!tagInfo.contains("Dragon")) continue;
                CompoundNBT draginTag = stack.func_77978_p().func_74775_l(tagInfo);
                String dragonName = new TranslationTextComponent(desc).func_150261_e();
                if (!draginTag.func_74779_i("CustomName").isEmpty()) {
                    dragonName = draginTag.func_74779_i("CustomName");
                }
                tooltip.add((ITextComponent)new TranslationTextComponent("item.iceandfire.summoning_crystal.bound", new Object[]{dragonName}).func_240699_a_(TextFormatting.GRAY));
                flag = true;
            }
        }
        if (!flag) {
            tooltip.add((ITextComponent)new TranslationTextComponent("item.iceandfire.summoning_crystal.desc_0").func_240699_a_(TextFormatting.GRAY));
            tooltip.add((ITextComponent)new TranslationTextComponent("item.iceandfire.summoning_crystal.desc_1").func_240699_a_(TextFormatting.GRAY));
        }
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        ItemStack stack = context.func_195999_j().func_184586_b(context.func_221531_n());
        boolean flag = false;
        BlockPos offsetPos = context.func_195995_a().func_177972_a(context.func_196000_l());
        float yaw = context.func_195999_j().field_70177_z;
        boolean displayError = false;
        if (stack.func_77973_b() == this && ItemSummoningCrystal.hasDragon(stack)) {
            int dragonCount = 0;
            if (stack.func_77978_p() != null) {
                for (String tagInfo : stack.func_77978_p().func_150296_c()) {
                    if (!tagInfo.contains("Dragon")) continue;
                    ++dragonCount;
                    CompoundNBT dragonTag = stack.func_77978_p().func_74775_l(tagInfo);
                    UUID id = dragonTag.func_186857_a("DragonUUID");
                    if (id == null || context.func_195991_k().field_72995_K) continue;
                    try {
                        Entity entity = context.func_195991_k().func_73046_m().func_71218_a(context.func_195999_j().field_70170_p.func_234923_W_()).func_217461_a(id);
                        if (entity != null) {
                            flag = true;
                            this.summonEntity(entity, context.func_195991_k(), offsetPos, yaw);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        displayError = true;
                    }
                    DragonPosWorldData data = DragonPosWorldData.get(context.func_195991_k());
                    BlockPos dragonChunkPos = null;
                    if (data != null) {
                        dragonChunkPos = data.getDragonPos(id);
                    }
                    if (!IafConfig.chunkLoadSummonCrystal) continue;
                    try {
                        boolean flag2 = false;
                        if (!flag && data != null && context.func_195991_k().field_72995_K) {
                            ServerWorld serverWorld = (ServerWorld)context.func_195991_k();
                            ChunkPos pos = new ChunkPos(dragonChunkPos);
                            serverWorld.func_217458_b(pos.field_77276_a, pos.field_77275_b, true);
                        }
                        if (!flag2) continue;
                        try {
                            Entity entity = context.func_195991_k().func_73046_m().func_71218_a(context.func_195999_j().field_70170_p.func_234923_W_()).func_217461_a(id);
                            if (entity == null) continue;
                            flag = true;
                            this.summonEntity(entity, context.func_195991_k(), offsetPos, yaw);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    catch (Exception e) {
                        IceAndFire.LOGGER.warn("Could not load chunk when summoning dragon");
                        e.printStackTrace();
                    }
                }
            }
            if (flag) {
                context.func_195999_j().func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
                context.func_195999_j().func_184185_a(SoundEvents.field_187561_bM, 1.0f, 1.0f);
                context.func_195999_j().func_184609_a(context.func_221531_n());
                context.func_195999_j().func_146105_b((ITextComponent)new TranslationTextComponent("message.iceandfire.dragonTeleport"), true);
                stack.func_77982_d(new CompoundNBT());
            } else if (displayError) {
                context.func_195999_j().func_146105_b((ITextComponent)new TranslationTextComponent("message.iceandfire.noDragonTeleport"), true);
            }
        }
        return ActionResultType.PASS;
    }

    public void summonEntity(Entity entity, World worldIn, BlockPos offsetPos, float yaw) {
        DragonPosWorldData data;
        entity.func_70012_b((double)offsetPos.func_177958_n() + 0.5, (double)offsetPos.func_177956_o() + 0.5, (double)offsetPos.func_177952_p() + 0.5, yaw, 0.0f);
        if (entity instanceof EntityDragonBase) {
            ((EntityDragonBase)entity).setCrystalBound(false);
        }
        if (IafConfig.chunkLoadSummonCrystal && (data = DragonPosWorldData.get(worldIn)) != null) {
            data.removeDragon(entity.func_110124_au());
        }
    }
}

